/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFLog;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandTiming;
import co.aikar.commands.ForwardingCommand;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Subcommand;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.util.StringUtil;

public abstract class BaseCommand
extends Command {
    private final SetMultimap<String, RegisteredCommand> subCommands = HashMultimap.create();
    private String execLabel;
    private String execSubcommand;
    private String[] origArgs;
    CommandManager manager = null;
    Map<String, Command> registeredCommands = new HashMap<String, Command>();

    public BaseCommand() {
        this(null);
    }

    public BaseCommand(String cmd) {
        super(cmd);
    }

    public String getExecCommandLabel() {
        return this.execLabel;
    }

    public String getExecSubcommand() {
        return this.execSubcommand;
    }

    public String[] getOrigArgs() {
        return this.origArgs;
    }

    void onRegister(CommandManager manager) {
        this.manager = manager;
        Class<?> self = ((Object)((Object)this)).getClass();
        CommandAlias rootCmdAlias = self.getAnnotation(CommandAlias.class);
        String cmd = this.getName();
        if (cmd == null) {
            cmd = rootCmdAlias == null ? "__" + self.getSimpleName() : ACFPatterns.PIPE.split(rootCmdAlias.value())[0];
            cmd = cmd.toLowerCase();
            try {
                this.setName(cmd);
            }
            catch (NoSuchMethodError ignored) {
                try {
                    Field field = Command.class.getDeclaredField("name");
                    field.setAccessible(true);
                    field.set((Object)this, cmd);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    ACFLog.exception("Error setting name for command", e);
                }
            }
            this.setLabel(cmd);
        }
        this.description = cmd + " commands";
        this.usageMessage = "/" + cmd;
        CommandPermission perm = self.getAnnotation(CommandPermission.class);
        if (perm != null) {
            this.setPermission(perm.value());
        }
        boolean foundDefault = false;
        for (Method method : self.getDeclaredMethods()) {
            method.setAccessible(true);
            String sublist = null;
            Subcommand sub = method.getAnnotation(Subcommand.class);
            Default def = method.getAnnotation(Default.class);
            CommandAlias commandAliases = method.getAnnotation(CommandAlias.class);
            if (def != null) {
                if (!foundDefault) {
                    this.registerSubcommand(method, "__default");
                    foundDefault = true;
                } else {
                    ACFUtil.sneaky((Throwable)new InvalidConfigurationException("Multiple @Default commands"));
                }
            }
            if (sub != null) {
                sublist = sub.value();
            } else if (commandAliases != null) {
                sublist = commandAliases.value();
            }
            if (sublist == null) continue;
            this.registerSubcommand(method, sublist);
        }
        try {
            Method unknown = self.getMethod("onUnknown", CommandSender.class, String.class, String[].class);
            unknown.setAccessible(true);
            this.registerSubcommand(unknown, "__unknown");
        }
        catch (NoSuchMethodException unknown) {
            // empty catch block
        }
        if (rootCmdAlias != null) {
            ArrayList cmdList = new ArrayList();
            Collections.addAll(cmdList, ACFPatterns.PIPE.split(rootCmdAlias.value().toLowerCase()));
            cmdList.remove(cmd);
            for (String cmdAlias : cmdList) {
                this.register(cmdAlias, new ForwardingCommand(this));
            }
        }
        this.register(this.getName(), this);
    }

    private void register(String name, Command cmd) {
        this.registeredCommands.put(name.toLowerCase(), cmd);
    }

    private void registerSubcommand(Method method, String subCommand) {
        subCommand = subCommand.toLowerCase();
        Object[] subCommandParts = ACFPatterns.SPACE.split(subCommand);
        List<String> cmdList = BaseCommand.getSubCommandPossibilityList((String[])subCommandParts);
        for (int i = 0; i < subCommandParts.length; ++i) {
            subCommandParts[i] = ACFPatterns.PIPE.split((CharSequence)subCommandParts[i])[0];
        }
        String prefSubCommand = StringUtils.join((Object[])subCommandParts, (String)" ");
        CommandAlias cmdAlias = method.getAnnotation(CommandAlias.class);
        String[] aliasNames = cmdAlias != null ? ACFPatterns.PIPE.split(cmdAlias.value().toLowerCase()) : null;
        String cmdName = aliasNames != null ? aliasNames[0] : this.getLabel() + " ";
        RegisteredCommand cmd = new RegisteredCommand(this, cmdName, method, prefSubCommand);
        for (String subcmd : cmdList) {
            this.subCommands.put((Object)subcmd, (Object)cmd);
        }
        if (aliasNames != null) {
            for (String name : aliasNames) {
                this.register(name, new ForwardingCommand(this, (String[])subCommandParts));
            }
        }
    }

    private static List<String> getSubCommandPossibilityList(String[] subCommandParts) {
        ArrayList<String> newList;
        int i = 0;
        ArrayList<String> current = null;
        while (true) {
            newList = new ArrayList<String>();
            if (i < subCommandParts.length) {
                for (String s1 : ACFPatterns.PIPE.split(subCommandParts[i])) {
                    if (current != null) {
                        newList.addAll(current.stream().map(s -> s + " " + s1).collect(Collectors.toList()));
                        continue;
                    }
                    newList.add(s1);
                }
            }
            if (i + 1 >= subCommandParts.length) break;
            current = newList;
            ++i;
        }
        return newList;
    }

    public final boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        commandLabel = commandLabel.toLowerCase();
        this.execSubcommand = null;
        this.execLabel = commandLabel;
        this.origArgs = args;
        if (args.length == 0) {
            if (this.preCommand(sender, commandLabel, args)) {
                return true;
            }
            this.onDefault(sender, commandLabel);
            return true;
        }
        CommandSearch cmd = this.findSubCommand(args);
        if (cmd != null) {
            this.execSubcommand = cmd.getCheckSub();
            String[] execargs = Arrays.copyOfRange(args, cmd.argIndex, args.length);
            if (this.preCommand(sender, commandLabel, execargs)) {
                return true;
            }
            BaseCommand.executeCommand(sender, execargs, cmd.cmd);
            return true;
        }
        if (!this.onUnknown(sender, commandLabel, args)) {
            this.help(sender, args);
        }
        return true;
    }

    private CommandSearch findSubCommand(String[] args) {
        return this.findSubCommand(args, false);
    }

    private CommandSearch findSubCommand(String[] args, boolean completion) {
        for (int i = args.length; i >= 0; --i) {
            String checkSub = StringUtils.join((Object[])args, (String)" ", (int)0, (int)i).toLowerCase();
            Set cmds = this.subCommands.get((Object)checkSub);
            int extraArgs = args.length - i;
            if (cmds.isEmpty()) continue;
            RegisteredCommand cmd = null;
            if (cmds.size() == 1) {
                cmd = (RegisteredCommand)Iterables.getOnlyElement((Iterable)cmds);
            } else {
                Optional<RegisteredCommand> optCmd = cmds.stream().filter(c -> {
                    int nonSender = c.nonSenderAwareResolvers;
                    int partialSender = c.optionalResolvers;
                    return extraArgs <= nonSender + partialSender && (completion || extraArgs >= nonSender);
                }).sorted((c1, c2) -> {
                    int a = c1.nonSenderAwareResolvers + c1.optionalResolvers;
                    int b = c2.nonSenderAwareResolvers + c2.optionalResolvers;
                    if (a == b) {
                        return 0;
                    }
                    return a < b ? 1 : -1;
                }).findFirst();
                if (optCmd.isPresent()) {
                    cmd = optCmd.get();
                }
            }
            if (cmd == null) continue;
            return new CommandSearch(cmd, i, checkSub);
        }
        return null;
    }

    private static void executeCommand(CommandSender sender, String[] args, RegisteredCommand cmd) {
        if (cmd.hasPermission(sender)) {
            ArrayList sargs = Lists.newArrayList((Object[])args);
            try (CommandTiming timing = cmd.getTiming().startTiming();){
                cmd.invoke(sender, sargs);
            }
        } else {
            ACFUtil.sendMsg(sender, "&cI'm sorry, but you do not have permission to perform this command.");
        }
    }

    public boolean canExecute(CommandSender sender, RegisteredCommand cmd) {
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String commandLabel, String[] args) throws IllegalArgumentException {
        commandLabel = commandLabel.toLowerCase();
        CommandSearch search = this.findSubCommand(args, true);
        if (search != null) {
            args = Arrays.copyOfRange(args, search.argIndex, args.length);
            return this.completeCommand(sender, search.cmd, args, commandLabel);
        }
        String argString = StringUtils.join((Object[])args, (String)" ").toLowerCase();
        ArrayList<String> cmds = new ArrayList<String>();
        for (Map.Entry entry : this.subCommands.entries()) {
            RegisteredCommand value;
            String key = (String)entry.getKey();
            if (!key.startsWith(argString) || "__unknown".equals(key) || "__default".equals(key) || !(value = (RegisteredCommand)entry.getValue()).hasPermission(sender)) continue;
            String prefCommand = value.prefSubCommand;
            String[] psplit = ACFPatterns.SPACE.split(prefCommand);
            cmds.add(psplit[args.length - 1]);
        }
        Set unknownCmds = this.subCommands.get((Object)"__unknown");
        if (cmds.isEmpty() && !unknownCmds.isEmpty()) {
            RegisteredCommand unknownCommand = null;
            if (unknownCmds.size() == 1) {
                unknownCommand = (RegisteredCommand)Iterables.getOnlyElement((Iterable)unknownCmds);
            }
            if (unknownCommand != null) {
                return this.completeCommand(sender, unknownCommand, args, commandLabel);
            }
        }
        return BaseCommand.filterTabComplete(args[args.length - 1], cmds);
    }

    private List<String> completeCommand(CommandSender sender, RegisteredCommand cmd, String[] args, String commandLabel) {
        if (args.length > cmd.nonSenderAwareResolvers + cmd.optionalResolvers) {
            return ImmutableList.of();
        }
        if (args.length == 0 || cmd.complete == null) {
            return args.length < 2 ? super.tabComplete(sender, commandLabel, args) : ImmutableList.of();
        }
        String[] completions = ACFPatterns.SPACE.split(cmd.complete.value());
        int argIndex = args.length - 1;
        String input = args[argIndex];
        String completion = argIndex < completions.length ? completions[argIndex] : null;
        ImmutableList cmds = this.manager.getCommandCompletions().of(sender, completion, input);
        if (cmds.isEmpty()) {
            cmds = ImmutableList.of((Object)input);
        }
        return BaseCommand.filterTabComplete(args[argIndex], (List<String>)cmds);
    }

    private static List<String> filterTabComplete(String arg, List<String> cmds) {
        return cmds.stream().distinct().filter(cmd -> cmd != null && (arg.isEmpty() || StringUtil.startsWithIgnoreCase((String)cmd, (String)arg))).collect(Collectors.toList());
    }

    public void help(CommandSender sender, String[] args) {
        ACFUtil.sendMsg(sender, "&cUnknown Command, please type &f/help");
    }

    public void onDefault(CommandSender sender, String commandLabel) {
        this.executeDefault(sender, new String[0]);
    }

    public boolean onUnknown(CommandSender sender, String commandLabel, String[] args) {
        this.help(sender, args);
        return true;
    }

    public boolean executeDefault(CommandSender sender, String ... args) {
        Set defs = this.subCommands.get((Object)"__default");
        RegisteredCommand def = null;
        if (!defs.isEmpty()) {
            if (defs.size() == 1) {
                def = (RegisteredCommand)Iterables.getOnlyElement((Iterable)defs);
            }
            if (def != null) {
                BaseCommand.executeCommand(sender, args, def);
                return true;
            }
        }
        return false;
    }

    public boolean preCommand(CommandSender sender, String commandLabel, String[] args) {
        return false;
    }

    public void doHelp(CommandSender sender, String ... args) {
        this.help(sender, args);
    }

    public void showSyntax(CommandSender sender, RegisteredCommand cmd) {
        ACFUtil.sendMsg(sender, "&cUsage: /" + cmd.command + " " + cmd.syntaxText);
    }

    private static class CommandSearch {
        RegisteredCommand cmd;
        int argIndex;
        String checkSub;

        CommandSearch(RegisteredCommand cmd, int argIndex, String checkSub) {
            this.cmd = cmd;
            this.argIndex = argIndex;
            this.checkSub = checkSub;
        }

        String getCheckSub() {
            return this.checkSub;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandSearch that = (CommandSearch)o;
            return this.argIndex == that.argIndex && Objects.equals(this.cmd, that.cmd) && Objects.equals(this.checkSub, that.checkSub);
        }

        public int hashCode() {
            return Objects.hash(this.cmd, this.argIndex, this.checkSub);
        }
    }
}

