/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFLog;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandTiming;
import co.aikar.commands.EmptyTiming;
import co.aikar.commands.MinecraftTiming;
import co.aikar.commands.SpigotTiming;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ACFUtil {
    public static final Random RANDOM = new Random();
    static TimingType timingProvider;

    private ACFUtil() {
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static String formatNumber(Integer balance) {
        return NumberFormat.getInstance().format(balance);
    }

    public static String formatLocation(Location loc) {
        if (loc == null) {
            return null;
        }
        return loc.getWorld().getName() + ":" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String color(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void sendMsg(CommandSender player, String message) {
        message = ACFUtil.color(message);
        if (player == null) {
            for (String msg : ACFPatterns.NEWLINE.split(message)) {
                ACFLog.info(msg);
            }
        } else {
            for (String msg : ACFPatterns.NEWLINE.split(message)) {
                player.sendMessage(msg);
            }
        }
    }

    public static Location stringToLocation(String storedLoc) {
        return ACFUtil.stringToLocation(storedLoc, null);
    }

    public static Location stringToLocation(String storedLoc, World forcedWorld) {
        String[] args2;
        if (storedLoc == null) {
            return null;
        }
        String[] args = ACFPatterns.COLON.split(storedLoc);
        if (args.length >= 4 || args.length == 3 && forcedWorld != null) {
            String world = forcedWorld != null ? forcedWorld.getName() : args[0];
            int i = args.length == 3 ? 0 : 1;
            double x = Double.parseDouble(args[i]);
            double y = Double.parseDouble(args[i + 1]);
            double z = Double.parseDouble(args[i + 2]);
            Location loc = new Location(Bukkit.getWorld((String)world), x, y, z);
            if (args.length >= 6) {
                loc.setPitch(Float.parseFloat(args[4]));
                loc.setYaw(Float.parseFloat(args[5]));
            }
            return loc;
        }
        if (args.length == 2 && (args2 = ACFPatterns.COMMA.split(args[1])).length == 3) {
            String world = forcedWorld != null ? forcedWorld.getName() : args[0];
            double x = Double.parseDouble(args2[0]);
            double y = Double.parseDouble(args2[1]);
            double z = Double.parseDouble(args2[2]);
            return new Location(Bukkit.getWorld((String)world), x, y, z);
        }
        return null;
    }

    public static String fullLocationToString(Location loc) {
        if (loc == null) {
            return null;
        }
        return new StringBuilder(64).append(loc.getWorld().getName()).append(':').append(ACFUtil.precision(loc.getX(), 4)).append(':').append(ACFUtil.precision(loc.getY(), 4)).append(':').append(ACFUtil.precision(loc.getZ(), 4)).append(':').append(ACFUtil.precision(loc.getPitch(), 4)).append(':').append(ACFUtil.precision(loc.getYaw(), 4)).toString();
    }

    public static String fullBlockLocationToString(Location loc) {
        if (loc == null) {
            return null;
        }
        return new StringBuilder(64).append(loc.getWorld().getName()).append(':').append(loc.getBlockX()).append(':').append(loc.getBlockY()).append(':').append(loc.getBlockZ()).append(':').append(ACFUtil.precision(loc.getPitch(), 4)).append(':').append(ACFUtil.precision(loc.getYaw(), 4)).toString();
    }

    public static String blockLocationToString(Location loc) {
        if (loc == null) {
            return null;
        }
        return new StringBuilder(32).append(loc.getWorld().getName()).append(':').append(loc.getBlockX()).append(':').append(loc.getBlockY()).append(':').append(loc.getBlockZ()).toString();
    }

    public static <T extends Enum> T getEnumFromName(T[] types, String name) {
        return (T)ACFUtil.getEnumFromName(types, (String)name, null);
    }

    public static <T extends Enum> T getEnumFromName(T[] types, String name, T def) {
        for (T type : types) {
            if (!((Enum)type).name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return def;
    }

    public static <T extends Enum> T getEnumFromOrdinal(T[] types, int ordinal) {
        for (T type : types) {
            if (((Enum)type).ordinal() != ordinal) continue;
            return type;
        }
        return null;
    }

    public static String ucfirst(String str) {
        return WordUtils.capitalizeFully((String)str);
    }

    public static Double parseDouble(String var) {
        return ACFUtil.parseDouble(var, null);
    }

    public static Double parseDouble(String var, Double def) {
        if (var == null) {
            return def;
        }
        try {
            return Double.parseDouble(var);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Float parseFloat(String var) {
        return ACFUtil.parseFloat(var, null);
    }

    public static Float parseFloat(String var, Float def) {
        if (var == null) {
            return def;
        }
        try {
            return Float.valueOf(Float.parseFloat(var));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Long parseLong(String var) {
        return ACFUtil.parseLong(var, null);
    }

    public static Long parseLong(String var, Long def) {
        if (var == null) {
            return def;
        }
        try {
            return Long.parseLong(var);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Integer parseInt(String var) {
        return ACFUtil.parseInt(var, null);
    }

    public static Integer parseInt(String var, Integer def) {
        if (var == null) {
            return def;
        }
        try {
            return Integer.parseInt(var);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static boolean randBool() {
        return RANDOM.nextBoolean();
    }

    public static <T> T nullDefault(Object val, Object def) {
        return (T)(val != null ? val : def);
    }

    public static String join(Collection<String> args) {
        return StringUtils.join(args, (String)" ");
    }

    public static String join(Collection<String> args, String sep) {
        return StringUtils.join(args, (String)sep);
    }

    public static String join(String[] args) {
        return ACFUtil.join(args, 0, ' ');
    }

    public static String join(String[] args, String sep) {
        return StringUtils.join((Object[])args, (String)sep);
    }

    public static String join(String[] args, char sep) {
        return ACFUtil.join(args, 0, sep);
    }

    public static String join(String[] args, int index) {
        return ACFUtil.join(args, index, ' ');
    }

    public static String join(String[] args, int index, char sep) {
        return StringUtils.join((Object[])args, (char)sep, (int)index, (int)args.length);
    }

    public static String simplifyString(String str) {
        if (str == null) {
            return null;
        }
        return ACFPatterns.NON_ALPHA_NUMERIC.matcher(str.toLowerCase()).replaceAll("");
    }

    public static double round(double x, int scale) {
        try {
            return new BigDecimal(Double.toString(x)).setScale(scale, 4).doubleValue();
        }
        catch (NumberFormatException ex) {
            if (Double.isInfinite(x)) {
                return x;
            }
            return Double.NaN;
        }
    }

    public static int roundUp(int num, int multiple) {
        if (multiple == 0) {
            return num;
        }
        int remainder = num % multiple;
        if (remainder == 0) {
            return num;
        }
        return num + multiple - remainder;
    }

    public static String removeColors(String msg) {
        return ChatColor.stripColor((String)ACFUtil.color(msg));
    }

    public static String replaceChatString(String message, String replace, String with) {
        return ACFUtil.replaceChatString(message, Pattern.compile(Pattern.quote(replace), 2), with);
    }

    public static String replaceChatString(String message, Pattern replace, String with) {
        String[] split = replace.split(message + "1");
        if (split.length < 2) {
            return replace.matcher(message).replaceAll(with);
        }
        message = split[0];
        for (int i = 1; i < split.length; ++i) {
            String prev = ChatColor.getLastColors((String)message);
            message = message + with + prev + split[i];
        }
        return message.substring(0, message.length() - 1);
    }

    public static boolean isWithinDistance(@NotNull Player p1, @NotNull Player p2, int dist) {
        return ACFUtil.isWithinDistance(p1.getLocation(), p2.getLocation(), dist);
    }

    public static boolean isWithinDistance(@NotNull Location loc1, @NotNull Location loc2, int dist) {
        return loc1.getWorld() == loc2.getWorld() && loc1.distance(loc2) <= (double)dist;
    }

    public static String limit(String str, int limit) {
        return str.length() > limit ? str.substring(0, limit) : str;
    }

    public static String replace(String string, Pattern pattern, String repl) {
        return pattern.matcher(string).replaceAll(Matcher.quoteReplacement(repl));
    }

    public static String replacePattern(String string, Pattern pattern, String repl) {
        return pattern.matcher(string).replaceAll(repl);
    }

    public static String replace(String string, String pattern, String repl) {
        return ACFUtil.replace(string, ACFPatterns.getPattern(Pattern.quote(pattern)), repl);
    }

    public static String replacePattern(String string, String pattern, String repl) {
        return ACFUtil.replace(string, ACFPatterns.getPattern(pattern), repl);
    }

    public static String replacePatternMatch(String string, Pattern pattern, String repl) {
        return pattern.matcher(string).replaceAll(repl);
    }

    public static String replacePatternMatch(String string, String pattern, String repl) {
        return ACFUtil.replacePatternMatch(string, ACFPatterns.getPattern(pattern), repl);
    }

    public static String replaceStrings(String string, String ... replacements) {
        if (replacements.length < 2 || replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid Replacements");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            String key = replacements[i];
            String value = replacements[i + 1];
            if (value == null) {
                value = "";
            }
            string = ACFUtil.replace(string, key, value);
        }
        return string;
    }

    public static String replacePatterns(String string, String ... replacements) {
        if (replacements.length < 2 || replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid Replacements");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            String key = replacements[i];
            String value = replacements[i + 1];
            if (value == null) {
                value = "";
            }
            string = ACFUtil.replacePattern(string, key, value);
        }
        return string;
    }

    public static String capitalize(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str == null || str.isEmpty() || delimLen == 0) {
            return str;
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (ACFUtil.isDelimiter(ch, delimiters)) {
                builder.append(ch);
                capitalizeNext = true;
                continue;
            }
            if (ch != ' ' && capitalizeNext) {
                builder.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        for (char delimiter : delimiters) {
            if (ch != delimiter) continue;
            return true;
        }
        return false;
    }

    public static <T> T random(List<T> arr) {
        if (arr == null || arr.isEmpty()) {
            return null;
        }
        return arr.get(RANDOM.nextInt(arr.size()));
    }

    public static <T> T random(T[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        return arr[RANDOM.nextInt(arr.length)];
    }

    @Deprecated
    public static <T extends Enum<?>> T random(Class<? extends T> enm) {
        return (T)((Enum)ACFUtil.random(enm.getEnumConstants()));
    }

    public static String normalize(String s) {
        if (s == null) {
            return null;
        }
        return ACFPatterns.NON_PRINTABLE_CHARACTERS.matcher(Normalizer.normalize(s, Normalizer.Form.NFD)).replaceAll("");
    }

    public static int indexOf(String arg, String[] split) {
        for (int i = 0; i < split.length; ++i) {
            if (!(arg == null ? split[i] == null : arg.equals(split[i]))) continue;
            return i;
        }
        return -1;
    }

    public static String capitalizeFirst(String name) {
        return ACFUtil.capitalizeFirst(name, '_');
    }

    public static String capitalizeFirst(String name, char separator) {
        name = name.toLowerCase();
        String[] split = name.split(Character.toString(separator));
        StringBuilder total = new StringBuilder(3);
        for (String s : split) {
            total.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(' ');
        }
        return total.toString().trim();
    }

    public static List<String> enumNames(Enum<?>[] values) {
        return Stream.of(values).map(Enum::name).collect(Collectors.toList());
    }

    public static List<String> enumNames(Class<? extends Enum<?>> cls) {
        return ACFUtil.enumNames(cls.getEnumConstants());
    }

    public static String combine(String[] args) {
        return ACFUtil.combine(args, 0);
    }

    public static String combine(String[] args, int start) {
        int size = 0;
        for (int i = start; i < args.length; ++i) {
            size += args[i].length();
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = start; i < args.length; ++i) {
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static double distance(@NotNull Entity e1, @NotNull Entity e2) {
        return ACFUtil.distance(e1.getLocation(), e2.getLocation());
    }

    public static double distance2d(@NotNull Entity e1, @NotNull Entity e2) {
        return ACFUtil.distance2d(e1.getLocation(), e2.getLocation());
    }

    public static double distance2d(@NotNull Location loc1, @NotNull Location loc2) {
        loc1 = loc1.clone();
        loc1.setY(loc2.getY());
        return ACFUtil.distance(loc1, loc2);
    }

    public static double distance(@NotNull Location loc1, @NotNull Location loc2) {
        if (loc1.getWorld() != loc2.getWorld()) {
            return 0.0;
        }
        return loc1.distance(loc2);
    }

    public static Location getTargetLoc(Player player) {
        return ACFUtil.getTargetLoc(player, 128);
    }

    public static Location getTargetLoc(Player player, int maxDist) {
        return ACFUtil.getTargetLoc(player, maxDist, 1.5);
    }

    public static Location getTargetLoc(Player player, int maxDist, double addY) {
        try {
            Location target = player.getTargetBlock((Set)null, maxDist).getLocation();
            target.setY(target.getY() + addY);
            return target;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Location getRandLoc(Location loc, int radius) {
        return ACFUtil.getRandLoc(loc, radius, radius, radius);
    }

    public static Location getRandLoc(Location loc, int xzRadius, int yRadius) {
        return ACFUtil.getRandLoc(loc, xzRadius, yRadius, xzRadius);
    }

    @NotNull
    public static Location getRandLoc(Location loc, int xRadius, int yRadius, int zRadius) {
        Location newLoc = loc.clone();
        newLoc.setX(ACFUtil.rand(loc.getX() - (double)xRadius, loc.getX() + (double)xRadius));
        newLoc.setY(ACFUtil.rand(loc.getY() - (double)yRadius, loc.getY() + (double)yRadius));
        newLoc.setZ(ACFUtil.rand(loc.getZ() - (double)zRadius, loc.getZ() + (double)zRadius));
        return newLoc;
    }

    @Nullable
    public static Enum<?> simpleMatch(Class<? extends Enum<?>> list, String item) {
        if (item == null) {
            return null;
        }
        item = ACFUtil.simplifyString(item);
        for (Enum<?> s : list.getEnumConstants()) {
            String simple = ACFUtil.simplifyString(s.name());
            if (!item.equals(simple)) continue;
            return s;
        }
        return null;
    }

    @NotNull
    public static Boolean isTruthy(String test) {
        switch (test) {
            case "t": 
            case "true": 
            case "on": 
            case "y": 
            case "yes": 
            case "1": {
                return true;
            }
        }
        return false;
    }

    public static Number parseNumber(String num, boolean suffixes) {
        double mod = 1.0;
        if (suffixes) {
            switch (num.charAt(num.length() - 1)) {
                case 'M': 
                case 'm': {
                    mod = 1000000.0;
                    num = num.substring(0, num.length() - 1);
                    break;
                }
                case 'K': 
                case 'k': {
                    mod = 1000.0;
                    num = num.substring(0, num.length() - 1);
                }
            }
        }
        return Double.parseDouble(num) * mod;
    }

    public static <T> boolean hasIntersection(Collection<T> list1, Collection<T> list2) {
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Collection<T> intersection(Collection<T> list1, Collection<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static int rand(int min, int max) {
        return min + RANDOM.nextInt(max - min + 1);
    }

    public static int rand(int min1, int max1, int min2, int max2) {
        return ACFUtil.randBool() ? ACFUtil.rand(min1, max1) : ACFUtil.rand(min2, max2);
    }

    public static double rand(double min, double max) {
        return RANDOM.nextDouble() * (max - min) + min;
    }

    public static boolean isNumber(String str) {
        return StringUtils.isNumeric((String)str);
    }

    public static String intToRoman(int integer) {
        if (integer == 1) {
            return "I";
        }
        if (integer == 2) {
            return "II";
        }
        if (integer == 3) {
            return "III";
        }
        if (integer == 4) {
            return "IV";
        }
        if (integer == 5) {
            return "V";
        }
        if (integer == 6) {
            return "VI";
        }
        if (integer == 7) {
            return "VII";
        }
        if (integer == 8) {
            return "VIII";
        }
        if (integer == 9) {
            return "IX";
        }
        if (integer == 10) {
            return "X";
        }
        return null;
    }

    public static boolean isInteger(String string) {
        return ACFPatterns.INTEGER.matcher(string).matches();
    }

    public static boolean isFloat(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBetween(float num, double min, double max) {
        return (double)num >= min && (double)num <= max;
    }

    public static double precision(double x, int p) {
        double pow = Math.pow(10.0, p);
        return (double)Math.round(x * pow) / pow;
    }

    public static Player findPlayerSmart(CommandSender requester, String origName) {
        Player player;
        String name = ACFUtil.replace(origName, ":confirm", "");
        if (name.length() < 3) {
            requester.sendMessage("\u00a7cUsername too short, must be at least three characters");
            return null;
        }
        if (!ACFUtil.isValidName(name)) {
            requester.sendMessage("\u00a7c'" + name + "' is not a valid username");
            return null;
        }
        List matches = Bukkit.getServer().matchPlayer(name);
        ArrayList<Player> confirmList = new ArrayList<Player>();
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            player = (Player)iter.next();
            if (!(requester instanceof Player) || ((Player)requester).canSee(player)) continue;
            if (requester.hasPermission("acf.seevanish")) {
                if (origName.endsWith(":confirm")) continue;
                confirmList.add(player);
                iter.remove();
                continue;
            }
            iter.remove();
        }
        if (matches.size() > 1 || confirmList.size() > 1) {
            requester.sendMessage("\u00a7cMultiple players matched '" + name + "', please be more specific");
            return null;
        }
        if (matches.isEmpty()) {
            if (confirmList.isEmpty()) {
                requester.sendMessage("\u00a7cNo player matching '" + name + "' is connected to this server");
                return null;
            }
            player = (Player)Iterables.getOnlyElement(confirmList);
            ACFUtil.sendMsg(requester, "&cWarning: " + player.getDisplayName() + "&c is vanished. Do not blow their cover!\n&cTo confirm your action, add &f:confirm&c to the end of their name. \n&bEx: &e/g " + player.getName() + ":confirm");
            return null;
        }
        return (Player)matches.get(0);
    }

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && ACFPatterns.VALID_NAME_PATTERN.matcher(name).matches();
    }

    public static void sneaky(Throwable t) {
        throw (RuntimeException)ACFUtil.superSneaky(t);
    }

    private static <T extends Throwable> T superSneaky(Throwable t) throws T {
        throw t;
    }

    public static synchronized CommandTiming getTiming(BaseCommand cmd, String command) {
        if (timingProvider == null) {
            try {
                Class.forName("co.aikar.timings.Timing");
                timingProvider = TimingType.MINECRAFT;
            }
            catch (ClassNotFoundException ignored1) {
                try {
                    Class.forName("org.spigotmc.CustomTimingsHandler");
                    timingProvider = TimingType.SPIGOT;
                }
                catch (ClassNotFoundException ignored2) {
                    timingProvider = TimingType.EMPTY;
                }
            }
        }
        return timingProvider.newTiming(cmd, command);
    }

    static boolean isValidItem(ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.getAmount() > 0;
    }

    private static enum TimingType {
        SPIGOT{

            @Override
            CommandTiming newTiming(BaseCommand cmd, String command) {
                return new SpigotTiming(command);
            }
        }
        ,
        MINECRAFT{

            @Override
            CommandTiming newTiming(BaseCommand cmd, String command) {
                return new MinecraftTiming(cmd, command);
            }
        }
        ,
        EMPTY;


        CommandTiming newTiming(BaseCommand cmd, String command) {
            return new EmptyTiming();
        }
    }
}

