/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFLog;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandTiming;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.annotation.Syntax;
import co.aikar.commands.annotation.Values;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.commands.contexts.SenderAwareContextResolver;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class RegisteredCommand {
    private final BaseCommand scope;
    public final String command;
    private final Method method;
    final String prefSubCommand;
    final Parameter[] parameters;
    final ContextResolver<?>[] resolvers;
    final String syntaxText;
    private final CommandPermission permission;
    final CommandCompletion complete;
    final int nonSenderAwareResolvers;
    final int optionalResolvers;
    private CommandTiming timing;

    RegisteredCommand(BaseCommand scope, String command, Method method, String prefSubCommand) {
        this.scope = scope;
        if ("__unknown".equals(prefSubCommand) || "__default".equals(prefSubCommand)) {
            prefSubCommand = "";
        }
        this.command = command + (method.getAnnotation(CommandAlias.class) == null && !prefSubCommand.isEmpty() ? prefSubCommand : "");
        this.method = method;
        this.prefSubCommand = prefSubCommand;
        this.permission = method.getAnnotation(CommandPermission.class);
        this.complete = method.getAnnotation(CommandCompletion.class);
        this.parameters = method.getParameters();
        this.resolvers = new ContextResolver[this.parameters.length];
        Syntax syntaxStr = method.getAnnotation(Syntax.class);
        CommandManager manager = scope.manager;
        CommandContexts commandContexts = manager.getCommandContexts();
        int nonSenderAwareResolvers = 0;
        int optionalResolvers = 0;
        StringBuilder syntaxB = new StringBuilder(64);
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = this.parameters[i];
            Class<?> type = parameter.getType();
            ContextResolver<?> resolver = commandContexts.getResolver(type);
            if (resolver != null) {
                this.resolvers[i] = resolver;
                if (type == World.class || resolver instanceof SenderAwareContextResolver || parameter.getAnnotation(Optional.class) != null || parameter.getAnnotation(Default.class) != null) {
                    ++optionalResolvers;
                } else {
                    ++nonSenderAwareResolvers;
                }
                if (CommandSender.class.isAssignableFrom(parameter.getType())) continue;
                if (parameter.getAnnotation(Default.class) != null || parameter.getAnnotation(Optional.class) != null || resolver instanceof SenderAwareContextResolver) {
                    syntaxB.append('[').append(parameter.getName()).append("] ");
                    continue;
                }
                syntaxB.append('<').append(parameter.getName()).append("> ");
                continue;
            }
            ACFUtil.sneaky((Throwable)new InvalidConfigurationException("Parameter " + type.getSimpleName() + " of " + this.command + " has no resolver"));
        }
        this.syntaxText = syntaxStr != null ? syntaxStr.value() : syntaxB.toString();
        this.nonSenderAwareResolvers = nonSenderAwareResolvers;
        this.optionalResolvers = optionalResolvers;
    }

    void invoke(CommandSender sender, List<String> args) {
        if (!this.scope.canExecute(sender, this)) {
            return;
        }
        try {
            LinkedHashMap passedArgs = Maps.newLinkedHashMap();
            for (int i = 0; i < this.parameters.length; ++i) {
                Values values;
                boolean isLast = i == this.parameters.length - 1;
                Parameter parameter = this.parameters[i];
                String parameterName = parameter.getName();
                Class<?> type = parameter.getType();
                ContextResolver<?> resolver = this.resolvers[i];
                CommandExecutionContext context = new CommandExecutionContext(this, parameter, sender, args, i, passedArgs);
                if (args.isEmpty() && (!isLast || type != String[].class)) {
                    Default def = parameter.getAnnotation(Default.class);
                    Optional opt = parameter.getAnnotation(Optional.class);
                    if (isLast && def != null) {
                        args.add(def.value());
                    } else {
                        if (isLast && opt != null) {
                            passedArgs.put(parameterName, resolver instanceof SenderAwareContextResolver ? (Object)resolver.getContext(context) : null);
                            continue;
                        }
                        if (!(resolver instanceof SenderAwareContextResolver)) {
                            this.scope.showSyntax(sender, this);
                            return;
                        }
                    }
                }
                if ((values = parameter.getAnnotation(Values.class)) != null) {
                    String arg = args.get(0);
                    String[] split = ACFPatterns.PIPE.split(values.value());
                    HashSet possible = Sets.newHashSet();
                    for (String s : split) {
                        List<String> check = this.scope.manager.getCommandCompletions().of(sender, s, arg);
                        if (!check.isEmpty()) {
                            possible.addAll(check.stream().map(String::toLowerCase).collect(Collectors.toList()));
                            continue;
                        }
                        possible.add(s.toLowerCase());
                    }
                    if (!possible.contains(arg.toLowerCase())) {
                        throw new InvalidCommandArgument("Must be one of: " + ACFUtil.join(possible, ", "));
                    }
                }
                passedArgs.put(parameterName, resolver.getContext(context));
            }
            this.method.invoke((Object)this.scope, passedArgs.values().toArray());
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof InvalidCommandArgument) {
                e = (Exception)e.getCause();
            }
            if (e instanceof InvalidCommandArgument) {
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    ACFUtil.sendMsg(sender, "&cError: " + e.getMessage());
                }
                if (((InvalidCommandArgument)e).showSyntax) {
                    this.scope.showSyntax(sender, this);
                }
            }
            ACFUtil.sendMsg(sender, "&cI'm sorry, but there was an error performing this command.");
            ACFLog.exception("Exception in command: " + this.command + " " + ACFUtil.join(args), e);
        }
    }

    CommandTiming getTiming() {
        if (this.timing == null) {
            this.timing = ACFUtil.getTiming(this.scope, this.command);
        }
        return this.timing;
    }

    boolean hasPermission(CommandSender check) {
        return this.permission == null || !(check instanceof Player) || check.hasPermission(this.permission.value());
    }

    public String getPrefSubCommand() {
        return this.prefSubCommand;
    }

    public String getSyntaxText() {
        return this.syntaxText;
    }

    public CommandPermission getPermission() {
        return this.permission;
    }
}

