/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandCompletions;
import co.aikar.commands.BukkitCommandContexts;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.plugin.Plugin;

public class BukkitCommandManager
implements CommandManager {
    protected final Plugin plugin;
    protected CommandContexts contexts;
    protected CommandCompletions completions;

    public BukkitCommandManager(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public CommandContexts getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new BukkitCommandContexts();
        }
        return this.contexts;
    }

    @Override
    public CommandCompletions getCommandCompletions() {
        if (this.completions == null) {
            this.completions = new BukkitCommandCompletions();
        }
        return this.completions;
    }

    @Override
    public boolean registerCommand(BaseCommand command) {
        String plugin = this.plugin.getName().toLowerCase();
        CommandMap commandMap = Bukkit.getServer().getCommandMap();
        command.onRegister(this);
        boolean allSuccess = true;
        for (Map.Entry<String, Command> entry : command.registeredCommands.entrySet()) {
            if (commandMap.register(entry.getKey().toLowerCase(), plugin, entry.getValue())) continue;
            allSuccess = false;
        }
        return allSuccess;
    }
}

