/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

final class ACFPatterns {
    public static final Pattern COMMA = Pattern.compile(",");
    public static final Pattern NEWLINE = Pattern.compile("\n");
    public static final Pattern DASH = Pattern.compile("-");
    public static final Pattern SPACE = Pattern.compile(" ");
    public static final Pattern SEMICOLON = Pattern.compile(";");
    public static final Pattern COLON = Pattern.compile(":");
    public static final Pattern PIPE = Pattern.compile("\\|");
    public static final Pattern NON_ALPHA_NUMERIC = Pattern.compile("[^a-zA-Z0-9]");
    public static final Pattern INTEGER = Pattern.compile("^[0-9]+$");
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{2,16}$");
    public static final Pattern NON_PRINTABLE_CHARACTERS = Pattern.compile("[^\\x20-\\x7F]");
    public static final Pattern EQUALS = Pattern.compile("=");
    static final LoadingCache<String, Pattern> patternCache = CacheBuilder.newBuilder().expireAfterAccess(90L, TimeUnit.DAYS).maximumSize(1024L).build(CacheLoader.from(pattern -> Pattern.compile(pattern)));

    private ACFPatterns() {
    }

    public static Pattern getPattern(String pattern) {
        try {
            return (Pattern)patternCache.get((Object)pattern);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Pattern.compile(pattern);
        }
    }
}

