/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;

final class ACFLog {
    private static final Logger LOGGER = Bukkit.getLogger();

    private ACFLog() {
    }

    public static void log(String message) {
        ACFLog.info(message);
    }

    public static void info(String message) {
        for (String s : ACFPatterns.NEWLINE.split(message)) {
            LOGGER.info(s);
        }
    }

    public static void warn(String message) {
        for (String s : ACFPatterns.NEWLINE.split(message)) {
            LOGGER.warning(s);
        }
    }

    public static void severe(String message) {
        for (String s : ACFPatterns.NEWLINE.split(message)) {
            LOGGER.severe(s);
        }
    }

    public static void error(String message) {
        ACFLog.severe(message);
    }

    public static void exception(String msg) {
        ACFLog.exception(new Throwable(msg));
    }

    public static void exception(Throwable e) {
        ACFLog.exception(e.getMessage(), e);
    }

    public static void exception(String msg, Throwable e) {
        if (msg != null) {
            ACFLog.severe(msg);
        }
        ACFLog.severe(ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    public static void exception(Throwable dbg, int lines) {
        if (dbg == null) {
            return;
        }
        ACFLog.severe(dbg.getMessage());
        StackTraceElement current = new Throwable().getStackTrace()[1];
        ACFLog.severe("c: " + current.getClassName() + ":" + current.getLineNumber());
        StackTraceElement[] stack = dbg.getStackTrace();
        for (int i = 0; i < lines && i < stack.length; ++i) {
            StackTraceElement cur = stack[i];
            Logger.getGlobal().severe("  " + cur);
        }
    }
}

