/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Multimap;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.HttpUserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.request.AuthenticationRequest;
import com.mojang.authlib.yggdrasil.request.RefreshRequest;
import com.mojang.authlib.yggdrasil.request.ValidateRequest;
import com.mojang.authlib.yggdrasil.response.AuthenticationResponse;
import com.mojang.authlib.yggdrasil.response.RefreshResponse;
import com.mojang.authlib.yggdrasil.response.Response;
import com.mojang.authlib.yggdrasil.response.User;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilUserAuthentication
extends HttpUserAuthentication {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_URL = "https://authserver.mojang.com/";
    private static final URL ROUTE_AUTHENTICATE = HttpAuthenticationService.constantURL("https://authserver.mojang.com/authenticate");
    private static final URL ROUTE_REFRESH = HttpAuthenticationService.constantURL("https://authserver.mojang.com/refresh");
    private static final URL ROUTE_VALIDATE = HttpAuthenticationService.constantURL("https://authserver.mojang.com/validate");
    private static final URL ROUTE_INVALIDATE = HttpAuthenticationService.constantURL("https://authserver.mojang.com/invalidate");
    private static final URL ROUTE_SIGNOUT = HttpAuthenticationService.constantURL("https://authserver.mojang.com/signout");
    private static final String STORAGE_KEY_ACCESS_TOKEN = "accessToken";
    private final Agent agent;
    private GameProfile[] profiles;
    private String accessToken;
    private boolean isOnline;

    public YggdrasilUserAuthentication(YggdrasilAuthenticationService var1, Agent var2) {
        super(var1);
        this.agent = var2;
    }

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank((CharSequence)this.getUsername()) && (StringUtils.isNotBlank((CharSequence)this.getPassword()) || StringUtils.isNotBlank((CharSequence)this.getAuthenticatedToken()));
    }

    @Override
    public void logIn() throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAuthenticatedToken())) {
            this.logInWithToken();
        } else {
            if (!StringUtils.isNotBlank((CharSequence)this.getPassword())) {
                throw new InvalidCredentialsException("Invalid password");
            }
            this.logInWithPassword();
        }
    }

    protected void logInWithPassword() throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank((CharSequence)this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        LOGGER.info("Logging in with username & password");
        AuthenticationRequest var1 = new AuthenticationRequest(this, this.getUsername(), this.getPassword());
        AuthenticationResponse var2 = (AuthenticationResponse)this.getAuthenticationService().makeRequest(ROUTE_AUTHENTICATE, var1, AuthenticationResponse.class);
        if (!var2.getClientToken().equals(this.getAuthenticationService().getClientToken())) {
            throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
        }
        if (var2.getSelectedProfile() != null) {
            this.setUserType(var2.getSelectedProfile().isLegacy() ? UserType.LEGACY : UserType.MOJANG);
        } else if (ArrayUtils.isNotEmpty((Object[])var2.getAvailableProfiles())) {
            this.setUserType(var2.getAvailableProfiles()[0].isLegacy() ? UserType.LEGACY : UserType.MOJANG);
        }
        User var3 = var2.getUser();
        if (var3 != null && var3.getId() != null) {
            this.setUserid(var3.getId());
        } else {
            this.setUserid(this.getUsername());
        }
        this.isOnline = true;
        this.accessToken = var2.getAccessToken();
        this.profiles = var2.getAvailableProfiles();
        this.setSelectedProfile(var2.getSelectedProfile());
        this.getModifiableUserProperties().clear();
        this.updateUserProperties(var3);
    }

    protected void updateUserProperties(User var1) {
        if (var1 != null && var1.getProperties() != null) {
            this.getModifiableUserProperties().putAll((Multimap)var1.getProperties());
        }
    }

    protected void logInWithToken() throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)this.getUserID())) {
            if (!StringUtils.isBlank((CharSequence)this.getUsername())) {
                throw new InvalidCredentialsException("Invalid uuid & username");
            }
            this.setUserid(this.getUsername());
        }
        if (StringUtils.isBlank((CharSequence)this.getAuthenticatedToken())) {
            throw new InvalidCredentialsException("Invalid access token");
        }
        LOGGER.info("Logging in with access token");
        if (this.checkTokenValidity()) {
            LOGGER.debug("Skipping refresh call as we're safely logged in.");
            this.isOnline = true;
        } else {
            RefreshRequest var1 = new RefreshRequest(this);
            RefreshResponse var2 = (RefreshResponse)this.getAuthenticationService().makeRequest(ROUTE_REFRESH, var1, RefreshResponse.class);
            if (!var2.getClientToken().equals(this.getAuthenticationService().getClientToken())) {
                throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
            }
            if (var2.getSelectedProfile() != null) {
                this.setUserType(var2.getSelectedProfile().isLegacy() ? UserType.LEGACY : UserType.MOJANG);
            } else if (ArrayUtils.isNotEmpty((Object[])var2.getAvailableProfiles())) {
                this.setUserType(var2.getAvailableProfiles()[0].isLegacy() ? UserType.LEGACY : UserType.MOJANG);
            }
            if (var2.getUser() != null && var2.getUser().getId() != null) {
                this.setUserid(var2.getUser().getId());
            } else {
                this.setUserid(this.getUsername());
            }
            this.isOnline = true;
            this.accessToken = var2.getAccessToken();
            this.profiles = var2.getAvailableProfiles();
            this.setSelectedProfile(var2.getSelectedProfile());
            this.getModifiableUserProperties().clear();
            this.updateUserProperties(var2.getUser());
        }
    }

    protected boolean checkTokenValidity() throws AuthenticationException {
        ValidateRequest var1 = new ValidateRequest(this);
        try {
            this.getAuthenticationService().makeRequest(ROUTE_VALIDATE, var1, Response.class);
            return true;
        }
        catch (AuthenticationException var3) {
            return false;
        }
    }

    @Override
    public void logOut() {
        super.logOut();
        this.accessToken = null;
        this.profiles = null;
        this.isOnline = false;
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        return this.profiles;
    }

    @Override
    public boolean isLoggedIn() {
        return StringUtils.isNotBlank((CharSequence)this.accessToken);
    }

    @Override
    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.isOnline;
    }

    @Override
    public void selectGameProfile(GameProfile var1) throws AuthenticationException {
        RefreshResponse var3;
        if (!this.isLoggedIn()) {
            throw new AuthenticationException("Cannot change game profile whilst not logged in");
        }
        if (this.getSelectedProfile() != null) {
            throw new AuthenticationException("Cannot change game profile. You must log out and back in.");
        }
        if (var1 != null && ArrayUtils.contains((Object[])this.profiles, (Object)var1)) {
            RefreshRequest var2 = new RefreshRequest(this, var1);
            var3 = (RefreshResponse)this.getAuthenticationService().makeRequest(ROUTE_REFRESH, var2, RefreshResponse.class);
            if (!var3.getClientToken().equals(this.getAuthenticationService().getClientToken())) {
                throw new AuthenticationException("Server requested we change our client token. Don't know how to handle this!");
            }
        } else {
            throw new IllegalArgumentException("Invalid profile '" + var1 + "'");
        }
        this.isOnline = true;
        this.accessToken = var3.getAccessToken();
        this.setSelectedProfile(var3.getSelectedProfile());
    }

    @Override
    public void loadFromStorage(Map var1) {
        super.loadFromStorage(var1);
        this.accessToken = String.valueOf(var1.get(STORAGE_KEY_ACCESS_TOKEN));
    }

    @Override
    public Map saveForStorage() {
        Map var1 = super.saveForStorage();
        if (StringUtils.isNotBlank((CharSequence)this.getAuthenticatedToken())) {
            var1.put(STORAGE_KEY_ACCESS_TOKEN, this.getAuthenticatedToken());
        }
        return var1;
    }

    @Deprecated
    public String getSessionToken() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.canPlayOnline() ? String.format("token:%s:%s", this.getAuthenticatedToken(), this.getSelectedProfile().getId()) : null;
    }

    @Override
    public String getAuthenticatedToken() {
        return this.accessToken;
    }

    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public String toString() {
        return "YggdrasilAuthenticationService{agent=" + this.agent + ", profiles=" + Arrays.toString(this.profiles) + ", selectedProfile=" + this.getSelectedProfile() + ", username='" + this.getUsername() + '\'' + ", isLoggedIn=" + this.isLoggedIn() + ", userType=" + (Object)((Object)this.getUserType()) + ", canPlayOnline=" + this.canPlayOnline() + ", accessToken='" + this.accessToken + '\'' + ", clientToken='" + this.getAuthenticationService().getClientToken() + '\'' + '}';
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }
}

