/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.request.JoinMinecraftServerRequest;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.authlib.yggdrasil.response.Response;
import com.mojang.util.UUIDTypeAdapter;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilMinecraftSessionService
extends HttpMinecraftSessionService {
    private static final String[] WHITELISTED_DOMAINS = new String[]{".minecraft.net", ".mojang.com"};
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_URL = "https://sessionserver.mojang.com/session/minecraft/";
    private static final URL JOIN_URL = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/join");
    private static final URL CHECK_URL = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/hasJoined");
    private final PublicKey publicKey;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
    private final LoadingCache insecureProfiles = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<GameProfile, GameProfile>(){

        public GameProfile load(GameProfile var1) throws Exception {
            return YggdrasilMinecraftSessionService.this.fillGameProfile(var1, false);
        }
    });

    protected YggdrasilMinecraftSessionService(YggdrasilAuthenticationService var1) {
        super(var1);
        try {
            X509EncodedKeySpec var2 = new X509EncodedKeySpec(IOUtils.toByteArray((InputStream)YggdrasilMinecraftSessionService.class.getResourceAsStream("/yggdrasil_session_pubkey.der")));
            KeyFactory var3 = KeyFactory.getInstance("RSA");
            this.publicKey = var3.generatePublic(var2);
        }
        catch (Exception var4) {
            throw new Error("Missing/invalid yggdrasil public key!");
        }
    }

    @Override
    public void joinServer(GameProfile var1, String var2, String var3) throws AuthenticationException {
        JoinMinecraftServerRequest var4 = new JoinMinecraftServerRequest();
        var4.accessToken = var2;
        var4.selectedProfile = var1.getId();
        var4.serverId = var3;
        this.getAuthenticationService().makeRequest(JOIN_URL, var4, Response.class);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile var1, String var2, InetAddress var3) throws AuthenticationUnavailableException {
        HashMap<String, String> var4 = new HashMap<String, String>();
        var4.put("username", var1.getName());
        var4.put("serverId", var2);
        if (var3 != null) {
            var4.put("ip", var3.getHostAddress());
        }
        URL var5 = HttpAuthenticationService.concatenateURL(CHECK_URL, HttpAuthenticationService.buildQuery(var4));
        try {
            HasJoinedMinecraftServerResponse var6 = (HasJoinedMinecraftServerResponse)this.getAuthenticationService().makeRequest(var5, null, HasJoinedMinecraftServerResponse.class);
            if (var6 != null && var6.getId() != null) {
                GameProfile var7 = new GameProfile(var6.getId(), var1.getName());
                if (var6.getProperties() != null) {
                    var7.getProperties().putAll((Multimap)var6.getProperties());
                }
                return var7;
            }
            return null;
        }
        catch (AuthenticationUnavailableException var8) {
            throw var8;
        }
        catch (AuthenticationException var9) {
            return null;
        }
    }

    @Override
    public Map getTextures(GameProfile var1, boolean var2) {
        Map.Entry var6;
        MinecraftTexturesPayload var4;
        Property var3 = (Property)Iterables.getFirst((Iterable)var1.getProperties().get("textures"), null);
        if (var3 == null) {
            return new HashMap();
        }
        if (var2) {
            if (!var3.hasSignature()) {
                LOGGER.error("Signature is missing from textures payload");
                throw new InsecureTextureException("Signature is missing from textures payload");
            }
            if (!var3.isSignatureValid(this.publicKey)) {
                LOGGER.error("Textures payload has been tampered with (signature invalid)");
                throw new InsecureTextureException("Textures payload has been tampered with (signature invalid)");
            }
        }
        try {
            String var5 = new String(Base64.decodeBase64((String)var3.getValue()), Charsets.UTF_8);
            var4 = (MinecraftTexturesPayload)this.gson.fromJson(var5, MinecraftTexturesPayload.class);
        }
        catch (JsonParseException var7) {
            LOGGER.error("Could not decode textures payload", (Throwable)var7);
            return new HashMap();
        }
        if (var4.getTextures() == null) {
            return new HashMap();
        }
        Iterator var8 = var4.getTextures().entrySet().iterator();
        do {
            if (var8.hasNext()) continue;
            return var4.getTextures();
        } while (YggdrasilMinecraftSessionService.isWhitelistedDomain(((MinecraftProfileTexture)(var6 = var8.next()).getValue()).getUrl()));
        LOGGER.error("Textures payload has been tampered with (non-whitelisted domain)");
        return new HashMap();
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile var1, boolean var2) {
        return var1.getId() == null ? var1 : (!var2 ? (GameProfile)this.insecureProfiles.getUnchecked((Object)var1) : this.fillGameProfile(var1, true));
    }

    protected GameProfile fillGameProfile(GameProfile var1, boolean var2) {
        try {
            URL var3 = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID(var1.getId()));
            var3 = HttpAuthenticationService.concatenateURL(var3, "unsigned=" + !var2);
            MinecraftProfilePropertiesResponse var4 = (MinecraftProfilePropertiesResponse)this.getAuthenticationService().makeRequest(var3, null, MinecraftProfilePropertiesResponse.class);
            if (var4 == null) {
                LOGGER.debug("Couldn't fetch profile properties for " + var1 + " as the profile does not exist");
                return var1;
            }
            GameProfile var5 = new GameProfile(var4.getId(), var4.getName());
            var5.getProperties().putAll((Multimap)var4.getProperties());
            var1.getProperties().putAll((Multimap)var4.getProperties());
            LOGGER.debug("Successfully fetched profile properties for " + var1);
            return var5;
        }
        catch (AuthenticationException var6) {
            LOGGER.warn("Couldn't look up profile properties for " + var1, (Throwable)var6);
            return var1;
        }
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }

    private static boolean isWhitelistedDomain(String var0) {
        URI var1 = null;
        try {
            var1 = new URI(var0);
        }
        catch (URISyntaxException var4) {
            throw new IllegalArgumentException("Invalid URL '" + var0 + "'");
        }
        String var2 = var1.getHost();
        for (int var3 = 0; var3 < WHITELISTED_DOMAINS.length; ++var3) {
            if (!var2.endsWith(WHITELISTED_DOMAINS[var3])) continue;
            return true;
        }
        return false;
    }
}

