/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.response.ProfileSearchResultsResponse;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilGameProfileRepository
implements GameProfileRepository {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_URL = "https://api.mojang.com/";
    private static final String SEARCH_PAGE_URL = "https://api.mojang.com/profiles/";
    private static final int ENTRIES_PER_PAGE = 2;
    private static final int MAX_FAIL_COUNT = 3;
    private static final int DELAY_BETWEEN_PAGES = 100;
    private static final int DELAY_BETWEEN_FAILURES = 750;
    private final YggdrasilAuthenticationService authenticationService;

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService var1) {
        this.authenticationService = var1;
    }

    @Override
    public void findProfilesByNames(String[] var1, Agent var2, ProfileLookupCallback var3) {
        HashSet var4 = Sets.newHashSet();
        String[] var5 = var1;
        int var6 = var1.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String var8 = var5[var7];
            if (Strings.isNullOrEmpty((String)var8)) continue;
            var4.add(var8.toLowerCase());
        }
        boolean var19 = false;
        for (List var21 : Iterables.partition((Iterable)var4, (int)2)) {
            boolean var9;
            int var22 = 0;
            do {
                var9 = false;
                try {
                    ProfileSearchResultsResponse var23 = (ProfileSearchResultsResponse)this.authenticationService.makeRequest(HttpAuthenticationService.constantURL(SEARCH_PAGE_URL + var2.getName().toLowerCase()), var21, ProfileSearchResultsResponse.class);
                    var22 = 0;
                    LOGGER.debug("Page {} returned {} results, parsing", new Object[]{0, var23.getProfiles().length});
                    HashSet var24 = Sets.newHashSet((Iterable)var21);
                    for (GameProfile var15 : var23.getProfiles()) {
                        LOGGER.debug("Successfully looked up profile {}", new Object[]{var15});
                        var24.remove(var15.getName().toLowerCase());
                        var3.onProfileLookupSucceeded(var15);
                    }
                    for (String var27 : var24) {
                        LOGGER.debug("Couldn't find profile {}", new Object[]{var27});
                        var3.onProfileLookupFailed(new GameProfile(null, var27), new ProfileNotFoundException("Server did not find the requested profile"));
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (AuthenticationException var18) {
                    AuthenticationException var10 = var18;
                    if (++var22 == 3) {
                        for (String var12 : var21) {
                            LOGGER.debug("Couldn't find profile {} because of a server error", new Object[]{var12});
                            var3.onProfileLookupFailed(new GameProfile(null, var12), var10);
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(750L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    var9 = true;
                }
            } while (var9);
        }
    }
}

