/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.legacy;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.HttpUserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.legacy.LegacyAuthenticationService;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class LegacyUserAuthentication
extends HttpUserAuthentication {
    private static final URL AUTHENTICATION_URL = HttpAuthenticationService.constantURL("https://login.minecraft.net");
    private static final int AUTHENTICATION_VERSION = 14;
    private static final int RESPONSE_PART_PROFILE_NAME = 2;
    private static final int RESPONSE_PART_SESSION_TOKEN = 3;
    private static final int RESPONSE_PART_PROFILE_ID = 4;
    private String sessionToken;

    protected LegacyUserAuthentication(LegacyAuthenticationService var1) {
        super(var1);
    }

    @Override
    public void logIn() throws AuthenticationException {
        String var6;
        String var5;
        String var4;
        String var2;
        if (StringUtils.isBlank((CharSequence)this.getUsername())) {
            throw new InvalidCredentialsException("Invalid username");
        }
        if (StringUtils.isBlank((CharSequence)this.getPassword())) {
            throw new InvalidCredentialsException("Invalid password");
        }
        HashMap<String, Object> var1 = new HashMap<String, Object>();
        var1.put("user", this.getUsername());
        var1.put("password", this.getPassword());
        var1.put("version", 14);
        try {
            var2 = this.getAuthenticationService().performPostRequest(AUTHENTICATION_URL, HttpAuthenticationService.buildQuery(var1), "application/x-www-form-urlencoded").trim();
        }
        catch (IOException var7) {
            throw new AuthenticationException("Authentication server is not responding", var7);
        }
        String[] var3 = var2.split(":");
        if (var3.length == 5) {
            var4 = var3[4];
            var5 = var3[2];
            var6 = var3[3];
            if (StringUtils.isBlank((CharSequence)var4) || StringUtils.isBlank((CharSequence)var5) || StringUtils.isBlank((CharSequence)var6)) {
                throw new AuthenticationException("Unknown response from authentication server: " + var2);
            }
        } else {
            throw new InvalidCredentialsException(var2);
        }
        this.setSelectedProfile(new GameProfile(UUIDTypeAdapter.fromString(var4), var5));
        this.sessionToken = var6;
        this.setUserType(UserType.LEGACY);
    }

    @Override
    public void logOut() {
        super.logOut();
        this.sessionToken = null;
    }

    @Override
    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.getAuthenticatedToken() != null;
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        GameProfile[] gameProfileArray;
        if (this.getSelectedProfile() != null) {
            GameProfile[] gameProfileArray2 = new GameProfile[1];
            gameProfileArray = gameProfileArray2;
            gameProfileArray2[0] = this.getSelectedProfile();
        } else {
            gameProfileArray = new GameProfile[]{};
        }
        return gameProfileArray;
    }

    @Override
    public void selectGameProfile(GameProfile var1) throws AuthenticationException {
        throw new UnsupportedOperationException("Game profiles cannot be changed in the legacy authentication service");
    }

    @Override
    public String getAuthenticatedToken() {
        return this.sessionToken;
    }

    @Override
    public String getUserID() {
        return this.getUsername();
    }

    @Override
    public LegacyAuthenticationService getAuthenticationService() {
        return (LegacyAuthenticationService)super.getAuthenticationService();
    }
}

