/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib;

import com.mojang.authlib.BaseAuthenticationService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HttpAuthenticationService
extends BaseAuthenticationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Proxy proxy;

    protected HttpAuthenticationService(Proxy var1) {
        Validate.notNull((Object)var1);
        this.proxy = var1;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    protected HttpURLConnection createUrlConnection(URL var1) throws IOException {
        Validate.notNull((Object)var1);
        LOGGER.debug("Opening connection to " + var1);
        HttpURLConnection var2 = (HttpURLConnection)var1.openConnection(this.proxy);
        var2.setConnectTimeout(15000);
        var2.setReadTimeout(15000);
        var2.setUseCaches(false);
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performPostRequest(URL var1, String var2, String var3) throws IOException {
        String var10;
        Validate.notNull((Object)var1);
        Validate.notNull((Object)var2);
        Validate.notNull((Object)var3);
        HttpURLConnection var4 = this.createUrlConnection(var1);
        byte[] var5 = var2.getBytes(Charsets.UTF_8);
        var4.setRequestProperty("Content-Type", var3 + "; charset=utf-8");
        var4.setRequestProperty("Content-Length", "" + var5.length);
        var4.setDoOutput(true);
        LOGGER.debug("Writing POST data to " + var1 + ": " + var2);
        OutputStream var6 = null;
        try {
            var6 = var4.getOutputStream();
            IOUtils.write((byte[])var5, (OutputStream)var6);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)var6);
        }
        LOGGER.debug("Reading data from " + var1);
        InputStream var7 = null;
        try {
            String var9;
            var7 = var4.getInputStream();
            String var8 = IOUtils.toString((InputStream)var7, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + var4.getResponseCode());
            LOGGER.debug("Response: " + var8);
            String string = var9 = var8;
            return string;
        }
        catch (IOException var19) {
            IOUtils.closeQuietly((InputStream)var7);
            var7 = var4.getErrorStream();
            if (var7 == null) {
                LOGGER.debug("Request failed", (Throwable)var19);
                throw var19;
            }
            LOGGER.debug("Reading error page from " + var1);
            String var9 = IOUtils.toString((InputStream)var7, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + var4.getResponseCode());
            LOGGER.debug("Response: " + var9);
            var10 = var9;
        }
        finally {
            IOUtils.closeQuietly((InputStream)var7);
        }
        return var10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performGetRequest(URL var1) throws IOException {
        String var6;
        Validate.notNull((Object)var1);
        HttpURLConnection var2 = this.createUrlConnection(var1);
        LOGGER.debug("Reading data from " + var1);
        InputStream var3 = null;
        try {
            String var5;
            var3 = var2.getInputStream();
            String var4 = IOUtils.toString((InputStream)var3, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + var2.getResponseCode());
            LOGGER.debug("Response: " + var4);
            String string = var5 = var4;
            return string;
        }
        catch (IOException var10) {
            IOUtils.closeQuietly((InputStream)var3);
            var3 = var2.getErrorStream();
            if (var3 == null) {
                LOGGER.debug("Request failed", (Throwable)var10);
                throw var10;
            }
            LOGGER.debug("Reading error page from " + var1);
            String var5 = IOUtils.toString((InputStream)var3, (Charset)Charsets.UTF_8);
            LOGGER.debug("Successful read, server response was " + var2.getResponseCode());
            LOGGER.debug("Response: " + var5);
            var6 = var5;
        }
        finally {
            IOUtils.closeQuietly((InputStream)var3);
        }
        return var6;
    }

    public static URL constantURL(String var0) {
        try {
            return new URL(var0);
        }
        catch (MalformedURLException var2) {
            throw new Error("Couldn't create constant for " + var0, var2);
        }
    }

    public static String buildQuery(Map var0) {
        if (var0 == null) {
            return "";
        }
        StringBuilder var1 = new StringBuilder();
        for (Map.Entry var3 : var0.entrySet()) {
            if (var1.length() > 0) {
                var1.append('&');
            }
            try {
                var1.append(URLEncoder.encode((String)var3.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var6) {
                LOGGER.error("Unexpected exception building query", (Throwable)var6);
            }
            if (var3.getValue() == null) continue;
            var1.append('=');
            try {
                var1.append(URLEncoder.encode(var3.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException var5) {
                LOGGER.error("Unexpected exception building query", (Throwable)var5);
            }
        }
        return var1.toString();
    }

    public static URL concatenateURL(URL var0, String var1) {
        try {
            return var0.getQuery() != null && var0.getQuery().length() > 0 ? new URL(var0.getProtocol(), var0.getHost(), var0.getPort(), var0.getFile() + "&" + var1) : new URL(var0.getProtocol(), var0.getHost(), var0.getPort(), var0.getFile() + "?" + var1);
        }
        catch (MalformedURLException var3) {
            throw new IllegalArgumentException("Could not concatenate given URL with GET arguments!", var3);
        }
    }
}

