/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib;

import com.google.common.collect.Multimap;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseUserAuthentication
implements UserAuthentication {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String STORAGE_KEY_PROFILE_NAME = "displayName";
    protected static final String STORAGE_KEY_PROFILE_ID = "uuid";
    protected static final String STORAGE_KEY_PROFILE_PROPERTIES = "profileProperties";
    protected static final String STORAGE_KEY_USER_NAME = "username";
    protected static final String STORAGE_KEY_USER_ID = "userid";
    protected static final String STORAGE_KEY_USER_PROPERTIES = "userProperties";
    private final AuthenticationService authenticationService;
    private final PropertyMap userProperties = new PropertyMap();
    private String userid;
    private String username;
    private String password;
    private GameProfile selectedProfile;
    private UserType userType;

    protected BaseUserAuthentication(AuthenticationService var1) {
        Validate.notNull((Object)var1);
        this.authenticationService = var1;
    }

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank((CharSequence)this.getUsername()) && StringUtils.isNotBlank((CharSequence)this.getPassword());
    }

    @Override
    public void logOut() {
        this.password = null;
        this.userid = null;
        this.setSelectedProfile(null);
        this.getModifiableUserProperties().clear();
        this.setUserType(null);
    }

    @Override
    public boolean isLoggedIn() {
        return this.getSelectedProfile() != null;
    }

    @Override
    public void setUsername(String var1) {
        if (this.isLoggedIn() && this.canPlayOnline()) {
            throw new IllegalStateException("Cannot change username whilst logged in & online");
        }
        this.username = var1;
    }

    @Override
    public void setPassword(String var1) {
        if (this.isLoggedIn() && this.canPlayOnline() && StringUtils.isNotBlank((CharSequence)var1)) {
            throw new IllegalStateException("Cannot set password whilst logged in & online");
        }
        this.password = var1;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    @Override
    public void loadFromStorage(Map var1) {
        String var7;
        String var6;
        this.logOut();
        this.setUsername(String.valueOf(var1.get(STORAGE_KEY_USER_NAME)));
        this.userid = var1.containsKey(STORAGE_KEY_USER_ID) ? String.valueOf(var1.get(STORAGE_KEY_USER_ID)) : this.username;
        if (var1.containsKey(STORAGE_KEY_USER_PROPERTIES)) {
            try {
                List var2 = (List)var1.get(STORAGE_KEY_USER_PROPERTIES);
                for (Map var4 : var2) {
                    String var5 = (String)var4.get("name");
                    var6 = (String)var4.get("value");
                    var7 = (String)var4.get("signature");
                    if (var7 == null) {
                        this.getModifiableUserProperties().put(var5, new Property(var5, var6));
                        continue;
                    }
                    this.getModifiableUserProperties().put(var5, new Property(var5, var6, var7));
                }
            }
            catch (Throwable var10) {
                LOGGER.warn("Couldn't deserialize user properties", var10);
            }
        }
        if (var1.containsKey(STORAGE_KEY_PROFILE_NAME) && var1.containsKey(STORAGE_KEY_PROFILE_ID)) {
            GameProfile var11 = new GameProfile(UUIDTypeAdapter.fromString(String.valueOf(var1.get(STORAGE_KEY_PROFILE_ID))), String.valueOf(var1.get(STORAGE_KEY_PROFILE_NAME)));
            if (var1.containsKey(STORAGE_KEY_PROFILE_PROPERTIES)) {
                try {
                    List var12 = (List)var1.get(STORAGE_KEY_PROFILE_PROPERTIES);
                    for (Map var14 : var12) {
                        var6 = (String)var14.get("name");
                        var7 = (String)var14.get("value");
                        String var8 = (String)var14.get("signature");
                        if (var8 == null) {
                            var11.getProperties().put(var6, new Property(var6, var7));
                            continue;
                        }
                        var11.getProperties().put(var6, new Property(var6, var7, var8));
                    }
                }
                catch (Throwable var9) {
                    LOGGER.warn("Couldn't deserialize profile properties", var9);
                }
            }
            this.setSelectedProfile(var11);
        }
    }

    @Override
    public Map saveForStorage() {
        GameProfile var7;
        HashMap<String, Object> var1 = new HashMap<String, Object>();
        if (this.getUsername() != null) {
            var1.put(STORAGE_KEY_USER_NAME, this.getUsername());
        }
        if (this.getUserID() != null) {
            var1.put(STORAGE_KEY_USER_ID, this.getUserID());
        } else if (this.getUsername() != null) {
            var1.put(STORAGE_KEY_USER_NAME, this.getUsername());
        }
        if (!this.getUserProperties().isEmpty()) {
            ArrayList var2 = new ArrayList();
            for (Property var4 : this.getUserProperties().values()) {
                HashMap<String, String> var5 = new HashMap<String, String>();
                var5.put("name", var4.getName());
                var5.put("value", var4.getValue());
                var5.put("signature", var4.getSignature());
                var2.add(var5);
            }
            var1.put(STORAGE_KEY_USER_PROPERTIES, var2);
        }
        if ((var7 = this.getSelectedProfile()) != null) {
            var1.put(STORAGE_KEY_PROFILE_NAME, var7.getName());
            var1.put(STORAGE_KEY_PROFILE_ID, var7.getId());
            ArrayList var8 = new ArrayList();
            for (Property var10 : var7.getProperties().values()) {
                HashMap<String, String> var6 = new HashMap<String, String>();
                var6.put("name", var10.getName());
                var6.put("value", var10.getValue());
                var6.put("signature", var10.getSignature());
                var8.add(var6);
            }
            if (!var8.isEmpty()) {
                var1.put(STORAGE_KEY_PROFILE_PROPERTIES, var8);
            }
        }
        return var1;
    }

    protected void setSelectedProfile(GameProfile var1) {
        this.selectedProfile = var1;
    }

    @Override
    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public String toString() {
        StringBuilder var1 = new StringBuilder();
        var1.append(this.getClass().getSimpleName());
        var1.append("{");
        if (this.isLoggedIn()) {
            var1.append("Logged in as ");
            var1.append(this.getUsername());
            if (this.getSelectedProfile() != null) {
                var1.append(" / ");
                var1.append(this.getSelectedProfile());
                var1.append(" - ");
                if (this.canPlayOnline()) {
                    var1.append("Online");
                } else {
                    var1.append("Offline");
                }
            }
        } else {
            var1.append("Not logged in");
        }
        var1.append("}");
        return var1.toString();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    @Override
    public String getUserID() {
        return this.userid;
    }

    @Override
    public PropertyMap getUserProperties() {
        if (this.isLoggedIn()) {
            PropertyMap var1 = new PropertyMap();
            var1.putAll((Multimap)this.getModifiableUserProperties());
            return var1;
        }
        return new PropertyMap();
    }

    protected PropertyMap getModifiableUserProperties() {
        return this.userProperties;
    }

    @Override
    public UserType getUserType() {
        return this.isLoggedIn() ? (this.userType == null ? UserType.LEGACY : this.userType) : null;
    }

    protected void setUserType(UserType var1) {
        this.userType = var1;
    }

    protected void setUserid(String var1) {
        this.userid = var1;
    }
}

