/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.particle.data;

import java.util.Objects;
import org.bukkit.Location;
import xyz.xenondevs.particle.ParticleConstants;
import xyz.xenondevs.particle.ParticleEffect;
import xyz.xenondevs.particle.data.ParticleData;
import xyz.xenondevs.particle.utils.ReflectionUtils;

public final class VibrationData
extends ParticleData {
    private final Location start;
    private final Location destination;
    private final int ticks;

    public VibrationData(Location start, Location destination, int ticks) {
        this.start = Objects.requireNonNull(start);
        this.destination = Objects.requireNonNull(destination);
        this.ticks = ticks;
    }

    public Location getStart() {
        return this.start;
    }

    public Location getDestination() {
        return this.destination;
    }

    public int getTicks() {
        return this.ticks;
    }

    @Override
    public Object toNMSData() {
        if (ReflectionUtils.MINECRAFT_VERSION < 17 || this.getEffect() != ParticleEffect.VIBRATION) {
            return null;
        }
        Object start = ReflectionUtils.createBlockPosition(this.getStart());
        Object dest = ReflectionUtils.createBlockPosition(this.getDestination());
        try {
            Object source = ParticleConstants.BLOCK_POSITION_SOURCE_CONSTRUCTOR.newInstance(dest);
            Object path = ParticleConstants.VIBRATION_PATH_CONSTRUCTOR.newInstance(start, source, this.getTicks());
            return ParticleConstants.PARTICLE_PARAM_VIBRATION_CONSTRUCTOR.newInstance(path);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

