/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.particle.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.xenondevs.particle.ParticleConstants;
import xyz.xenondevs.particle.utils.PlayerConnectionCache;

public final class ReflectionUtils {
    private static final String NET_MINECRAFT_SERVER_PACKAGE_PATH;
    private static final String CRAFT_BUKKIT_PACKAGE_PATH;
    public static final int MINECRAFT_VERSION;
    public static final PlayerConnectionCache PLAYER_CONNECTION_CACHE;
    public static Plugin plugin;

    public static Class<?> getClassSafe(String path) {
        try {
            return Class.forName(path);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getNMSPath(String path) {
        return ReflectionUtils.getNetMinecraftServerPackagePath() + "." + path;
    }

    public static Class<?> getNMSClass(String path) {
        return ReflectionUtils.getClassSafe(ReflectionUtils.getNMSPath(path));
    }

    public static String getCraftBukkitPath(String path) {
        return ReflectionUtils.getCraftBukkitPackagePath() + "." + path;
    }

    public static Class<?> getCraftBukkitClass(String path) {
        return ReflectionUtils.getClassSafe(ReflectionUtils.getCraftBukkitPath(path));
    }

    public static Method getMethodOrNull(Class targetClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return targetClass.getMethod(methodName, parameterTypes);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Field getFieldOrNull(Class targetClass, String fieldName, boolean declared) {
        try {
            return declared ? targetClass.getDeclaredField(fieldName) : targetClass.getField(fieldName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Constructor getConstructorOrNull(Class targetClass, Class ... parameterTypes) {
        try {
            return targetClass.getConstructor(parameterTypes);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean existsClass(String path) {
        try {
            Class.forName(path);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static Object readField(Class targetClass, String fieldName, Object object) {
        if (targetClass == null || fieldName == null) {
            return null;
        }
        return ReflectionUtils.readField(ReflectionUtils.getFieldOrNull(targetClass, fieldName, false), object);
    }

    public static <T> T readField(Field field, Object object) {
        if (field == null) {
            return null;
        }
        try {
            return (T)field.get(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object readDeclaredField(Class targetClass, String fieldName, Object object) {
        if (targetClass == null || fieldName == null) {
            return null;
        }
        return ReflectionUtils.readDeclaredField(ReflectionUtils.getFieldOrNull(targetClass, fieldName, true), object);
    }

    public static <T> T readDeclaredField(Field field, Object object) {
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (T)field.get(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void writeDeclaredField(Class targetClass, String fieldName, Object object, Object value) {
        if (targetClass == null || fieldName == null) {
            return;
        }
        ReflectionUtils.writeDeclaredField(ReflectionUtils.getFieldOrNull(targetClass, fieldName, true), object, value);
    }

    public static void writeDeclaredField(Field field, Object object, Object value) {
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeField(Class targetClass, String fieldName, Object object, Object value) {
        if (targetClass == null || fieldName == null) {
            return;
        }
        ReflectionUtils.writeField(ReflectionUtils.getFieldOrNull(targetClass, fieldName, false), object, value);
    }

    public static void writeField(Field field, Object object, Object value) {
        if (field == null) {
            return;
        }
        try {
            field.set(object, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getNetMinecraftServerPackagePath() {
        return NET_MINECRAFT_SERVER_PACKAGE_PATH;
    }

    public static String getCraftBukkitPackagePath() {
        return CRAFT_BUKKIT_PACKAGE_PATH;
    }

    public static Object getMinecraftKey(String key) {
        if (key == null) {
            return null;
        }
        try {
            return ParticleConstants.MINECRAFT_KEY_CONSTRUCTOR.newInstance(key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object createVector3fa(float x, float y, float z) {
        try {
            return ParticleConstants.VECTOR_3FA_CONSTRUCTOR.newInstance(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object createBlockPosition(Location location) {
        try {
            return ParticleConstants.BLOCK_POSITION_CONSTRUCTOR.newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getPlayerHandle(Player player) {
        if (player == null || player.getClass() != ParticleConstants.CRAFT_PLAYER_CLASS) {
            return null;
        }
        try {
            return ParticleConstants.CRAFT_PLAYER_GET_HANDLE_METHOD.invoke((Object)player, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getPlayerConnection(Player target) {
        try {
            return ReflectionUtils.readField(ParticleConstants.ENTITY_PLAYER_PLAYER_CONNECTION_FIELD, ReflectionUtils.getPlayerHandle(target));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object connection = PLAYER_CONNECTION_CACHE.getConnection(player);
            ParticleConstants.PLAYER_CONNECTION_SEND_PACKET_METHOD.invoke(connection, packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String serverPath = Bukkit.getServer().getClass().getPackage().getName();
        String version = serverPath.substring(serverPath.lastIndexOf(".") + 1);
        String packageVersion = serverPath.substring(serverPath.lastIndexOf(".") + 2);
        MINECRAFT_VERSION = Integer.parseInt(packageVersion.substring(0, packageVersion.lastIndexOf("_")).replace("_", ".").substring(2));
        NET_MINECRAFT_SERVER_PACKAGE_PATH = "net.minecraft" + (MINECRAFT_VERSION < 17 ? ".server." + version : "");
        CRAFT_BUKKIT_PACKAGE_PATH = "org.bukkit.craftbukkit." + version;
        plugin = (Plugin)ReflectionUtils.readDeclaredField(ParticleConstants.PLUGIN_CLASS_LOADER_PLUGIN_FIELD, ReflectionUtils.class.getClassLoader());
        PLAYER_CONNECTION_CACHE = new PlayerConnectionCache();
    }
}

