/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.renderer;

import java.util.List;
import java.util.Map;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public abstract class CustomRenderer {
    private static final int[] default_patches = new int[6];

    protected CustomRenderer() {
    }

    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        return true;
    }

    public void cleanupRenderer() {
    }

    public String[] getTileEntityFieldsNeeded() {
        return null;
    }

    protected int getMaximumTextureCount() {
        return 1;
    }

    public int getMaximumTextureCount(RenderPatchFactory rpf) {
        return this.getMaximumTextureCount();
    }

    public abstract RenderPatch[] getRenderPatchList(MapDataContext var1);

    private static void addIfNonNull(List<RenderPatch> list, RenderPatch p) {
        if (p != null) {
            list.add(p);
        }
    }

    public static void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, int[] patchids) {
        if (patchids == null) {
            patchids = default_patches;
        }
        if (patchids[0] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, ymin, 0.0, 1.0, ymin, 0.0, 0.0, ymin, 1.0, xmin, xmax, zmin, zmax, RenderPatchFactory.SideVisible.TOP, patchids[0]));
        }
        if (patchids[1] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, ymax, 1.0, 1.0, ymax, 1.0, 0.0, ymax, 0.0, xmin, xmax, 1.0 - zmax, 1.0 - zmin, RenderPatchFactory.SideVisible.TOP, patchids[1]));
        }
        if (patchids[2] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(xmin, 0.0, 0.0, xmin, 0.0, 1.0, xmin, 1.0, 0.0, zmin, zmax, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[2]));
        }
        if (patchids[3] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(xmax, 0.0, 1.0, xmax, 0.0, 0.0, xmax, 1.0, 1.0, 1.0 - zmax, 1.0 - zmin, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[3]));
        }
        if (patchids[4] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(1.0, 0.0, zmin, 0.0, 0.0, zmin, 1.0, 1.0, zmin, 1.0 - xmax, 1.0 - xmin, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[4]));
        }
        if (patchids[5] >= 0) {
            CustomRenderer.addIfNonNull(list, rpf.getPatch(0.0, 0.0, zmax, 1.0, 0.0, zmax, 0.0, 1.0, zmax, xmin, xmax, ymin, ymax, RenderPatchFactory.SideVisible.TOP, patchids[5]));
        }
    }

    public RenderPatch getSidePatch(RenderPatchFactory rpf, int side, double setback, double umin, double umax, double vmin, double vmax, int rot, int textureidx) {
        RenderPatch rp = null;
        switch (side) {
            case 0: {
                rp = rpf.getPatch(0.0, setback, 0.0, 1.0, setback, 0.0, 0.0, setback, 1.0, umin, umax, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, rot, 0, textureidx);
                break;
            }
            case 1: {
                rp = rpf.getPatch(0.0, 1.0 - setback, 1.0, 1.0, 1.0 - setback, 1.0, 0.0, 1.0 - setback, 0.0, umin, umax, 1.0 - vmax, 1.0 - vmin, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, 360 - rot, 0, textureidx);
                break;
            }
            case 2: {
                rp = rpf.getPatch(1.0, 0.0, setback, 0.0, 0.0, setback, 1.0, 1.0, setback, 1.0 - umax, 1.0 - umin, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, 0, rot, textureidx);
                break;
            }
            case 3: {
                rp = rpf.getPatch(0.0, 0.0, 1.0 - setback, 1.0, 0.0, 1.0 - setback, 0.0, 1.0, 1.0 - setback, umin, umax, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 0, 0, 360 - rot, textureidx);
                break;
            }
            case 4: {
                rp = rpf.getPatch(setback, 0.0, 0.0, setback, 0.0, 1.0, setback, 1.0, 0.0, umin, umax, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, rot, 0, 0, textureidx);
                break;
            }
            case 5: {
                rp = rpf.getPatch(1.0 - setback, 0.0, 1.0, 1.0 - setback, 0.0, 0.0, 1.0 - setback, 1.0, 1.0, 1.0 - umax, 1.0 - umin, vmin, vmax, RenderPatchFactory.SideVisible.TOP, textureidx);
                if (rot == 0) break;
                rp = rpf.getRotatedPatch(rp, 360 - rot, 0, 0, textureidx);
            }
        }
        return rp;
    }

    public RenderPatch getSidePatch(RenderPatchFactory rpf, int side, int rot, int textureidx) {
        return this.getSidePatch(rpf, side, 0.0, 0.0, 1.0, 0.0, 1.0, rot, textureidx);
    }
}

