/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.concurrent.CopyOnWriteArrayList;
import org.dynmap.DynmapCommonAPI;

public abstract class DynmapCommonAPIListener {
    private static DynmapCommonAPI dynmapapi = null;
    private static CopyOnWriteArrayList<DynmapCommonAPIListener> listeners = new CopyOnWriteArrayList();

    public abstract void apiEnabled(DynmapCommonAPI var1);

    public void apiDisabled(DynmapCommonAPI api) {
    }

    public void apiListenerAdded() {
    }

    public boolean webChatEvent(String source, String name, String message) {
        return true;
    }

    public static void register(DynmapCommonAPIListener listener) {
        listeners.add(listener);
        if (dynmapapi != null) {
            listener.apiEnabled(dynmapapi);
        } else {
            for (DynmapCommonAPIListener l : listeners) {
                l.apiListenerAdded();
            }
        }
    }

    public static void unregister(DynmapCommonAPIListener listener) {
        listeners.remove(listener);
    }

    public static void apiInitialized(DynmapCommonAPI api) {
        if (dynmapapi != null) {
            DynmapCommonAPIListener.apiTerminated();
        }
        if ((dynmapapi = api) != null) {
            for (DynmapCommonAPIListener l : listeners) {
                l.apiEnabled(api);
            }
        }
    }

    public static void apiTerminated() {
        if (dynmapapi != null) {
            for (DynmapCommonAPIListener l : listeners) {
                l.apiDisabled(dynmapapi);
            }
            dynmapapi = null;
        }
    }

    public static boolean fireWebChatEvent(String source, String name, String message) {
        boolean noCancel = true;
        if (dynmapapi != null) {
            for (DynmapCommonAPIListener l : listeners) {
                boolean bl = noCancel = l.webChatEvent(source, name, message) && noCancel;
            }
            dynmapapi = null;
        }
        return noCancel;
    }
}

