/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v115;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.server.v1_15_R1.BiomeBase;
import net.minecraft.server.v1_15_R1.Block;
import net.minecraft.server.v1_15_R1.BlockFluids;
import net.minecraft.server.v1_15_R1.BlockLogAbstract;
import net.minecraft.server.v1_15_R1.IBlockData;
import net.minecraft.server.v1_15_R1.IRegistry;
import net.minecraft.server.v1_15_R1.Material;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import org.dynmap.DynmapChunk;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitVersionHelperCB;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v115.MapChunkCache115;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class BukkitVersionHelperSpigot115
extends BukkitVersionHelperCB {
    protected Class<?> datapalettearray = this.getNMSClass("[Lnet.minecraft.server.DataPaletteBlock;");
    private Field blockid_field = this.getPrivateField(this.craftchunksnapshot, new String[]{"blockids"}, this.datapalettearray);
    public static IdentityHashMap<IBlockData, DynmapBlockState> dataToState;
    private String[] biomenames;

    protected boolean isBlockIdNeeded() {
        return false;
    }

    protected boolean isBiomeBaseListNeeded() {
        return false;
    }

    public Object[] getBlockIDFieldFromSnapshot(ChunkSnapshot css) {
        try {
            return (Object[])this.blockid_field.get(css);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public void unloadChunkNoSave(World w, Chunk c, int cx, int cz) {
        w.unloadChunk(cx, cz, false);
    }

    public String[] getBlockNames() {
        int cnt = Block.REGISTRY_ID.a();
        String[] names = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            IBlockData bd = Block.getByCombinedId((int)i);
            names[i] = IRegistry.BLOCK.getKey((Object)bd.getBlock()).toString();
            Log.info((String)(i + ": blk=" + names[i] + ", bd=" + bd.toString()));
        }
        return names;
    }

    public Object[] getBiomeBaseList() {
        if (this.biomelist == null) {
            this.biomelist = new Object[1024];
            for (int i = 0; i < 1024; ++i) {
                this.biomelist[i] = IRegistry.BIOME.fromId(i);
            }
        }
        return this.biomelist;
    }

    public int getBiomeBaseID(Object bb) {
        return IRegistry.BIOME.a((Object)((BiomeBase)bb));
    }

    public void initializeBlockStates() {
        dataToState = new IdentityHashMap();
        HashMap<String, DynmapBlockState> lastBlockState = new HashMap<String, DynmapBlockState>();
        int cnt = Block.REGISTRY_ID.a();
        for (int i = 0; i < cnt; ++i) {
            IBlockData bd = Block.getByCombinedId((int)i);
            String bname = IRegistry.BLOCK.getKey((Object)bd.getBlock()).toString();
            DynmapBlockState lastbs = (DynmapBlockState)lastBlockState.get(bname);
            int idx = 0;
            if (lastbs != null) {
                idx = lastbs.getStateCount();
            }
            String sb = "";
            String fname = bd.toString();
            int off1 = fname.indexOf(91);
            if (off1 >= 0) {
                int off2 = fname.indexOf(93);
                sb = fname.substring(off1 + 1, off2);
            }
            Material mat = bd.getMaterial();
            DynmapBlockState bs = new DynmapBlockState(lastbs, idx, bname, sb, mat.toString());
            if (!bd.getFluid().isEmpty() && !(bd.getBlock() instanceof BlockFluids)) {
                bs.setWaterlogged();
            }
            if (mat == Material.AIR) {
                bs.setAir();
            }
            if (mat == Material.LEAVES) {
                bs.setLeaves();
            }
            if (bd.getBlock() instanceof BlockLogAbstract) {
                bs.setLog();
            }
            if (mat.isSolid()) {
                bs.setSolid();
            }
            dataToState.put(bd, bs);
            lastBlockState.put(bname, lastbs == null ? bs : lastbs);
            Log.verboseinfo((String)(i + ": blk=" + bname + ", idx=" + idx + ", state=" + sb + ", waterlogged=" + bs.isWaterlogged()));
        }
    }

    public MapChunkCache getChunkCache(BukkitWorld dw, List<DynmapChunk> chunks) {
        MapChunkCache115 c = new MapChunkCache115();
        c.setChunks(dw, chunks);
        return c;
    }

    public int getBiomeBaseWaterMult(Object bb) {
        return ((BiomeBase)bb).o();
    }

    public float getBiomeBaseTemperature(Object bb) {
        return ((BiomeBase)bb).getTemperature();
    }

    public float getBiomeBaseHumidity(Object bb) {
        return ((BiomeBase)bb).getHumidity();
    }

    public Polygon getWorldBorder(World world) {
        Polygon p = null;
        WorldBorder wb = world.getWorldBorder();
        if (wb != null) {
            Location c = wb.getCenter();
            double size = wb.getSize();
            if (size > 1.0 && size < 1.0E7) {
                p = new Polygon();
                p.addVertex(c.getX() - (size /= 2.0), c.getZ() - size);
                p.addVertex(c.getX() + size, c.getZ() - size);
                p.addVertex(c.getX() + size, c.getZ() + size);
                p.addVertex(c.getX() - size, c.getZ() + size);
            }
        }
        return p;
    }

    public void sendTitleText(Player p, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTIcks) {
        if (p != null) {
            p.sendTitle(title, subtitle, fadeInTicks, stayTicks, fadeOutTIcks);
        }
    }

    public String[] getBiomeNames() {
        if (this.biomenames == null) {
            this.biomenames = new String[1024];
            for (int i = 0; i < 1024; ++i) {
                BiomeBase bb = (BiomeBase)IRegistry.BIOME.fromId(i);
                if (bb == null) continue;
                this.biomenames[i] = bb.t();
            }
        }
        return this.biomenames;
    }
}

