/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.renderer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynmapBlockState {
    public final int stateIndex;
    public final DynmapBlockState baseState;
    public final String blockName;
    public final String stateName;
    public final String[] stateList;
    public final int globalStateIndex;
    public final int legacyBlockID;
    public int lightAttenuation;
    private DynmapBlockState[] states;
    private int stateLastIdx = 0;
    private ConcurrentHashMap<String, DynmapBlockState> lookup;
    private final String fullName;
    public final String material;
    private static int nextGlobalStateIndex = 0;
    private int matchflags;
    private static int MATCH_AIR = 1;
    private static int MATCH_WATER = 2;
    private static int MATCH_SNOW = 4;
    private static int MATCH_LOG = 8;
    private static int MATCH_GRASS = 16;
    private static int MATCH_WATERLOGGED = 32;
    private static int MATCH_LEAVES = 64;
    private static int MATCH_SOLID = 128;
    private static HashMap<String, DynmapBlockState> blocksByName = new HashMap();
    private static HashMap<Integer, DynmapBlockState> blocksByIndex = new HashMap();
    private static HashMap<Integer, DynmapBlockState> blocksByLegacyID = new HashMap();
    private static DynmapBlockState[] blockArrayByIndex = null;
    private static DynmapBlockState[] blockArrayByLegacyID = null;
    public static String AIR_BLOCK = "minecraft:air";
    public static String STONE_BLOCK = "minecraft:stone";
    public static String GRASS_BLOCK = "minecraft:grass";
    public static String GOLD_ORE_BLOCK = "minecraft:gold_ore";
    public static String IRON_ORE_BLOCK = "minecraft:iron_ore";
    public static String COAL_ORE_BLOCK = "minecraft:coal_ore";
    public static String LAPIS_ORE_BLOCK = "minecraft:lapis_ore";
    public static String DIAMOND_ORE_BLOCK = "minecraft:diamond_ore";
    public static String REDSTONE_ORE_BLOCK = "minecraft:redstone_ore";
    public static String LIT_REDSTONE_ORE_BLOCK = "minecraft:lit_redstone_ore";
    public static String EMERALD_ORE_BLOCK = "minecraft:emerald_ore";
    public static String QUARTZ_ORE_BLOCK = "minecraft:nether_quartz_ore";
    public static String NETHER_GOLD_ORE_BLOCK = "minecraft:nether_gold_ore";
    public static String DEEPSLATE_GOLD_ORE_BLOCK = "minecraft:deepslate_gold_ore";
    public static String DEEPSLATE_IRON_ORE_BLOCK = "minecraft:deepslate_iron_ore";
    public static String DEEPSLATE_COAL_ORE_BLOCK = "minecraft:deepslate_coal_ore";
    public static String DEEPSLATE_LAPIS_ORE_BLOCK = "minecraft:deepslate_lapis_ore";
    public static String DEEPSLATE_DIAMOND_ORE_BLOCK = "minecraft:deepslate_diamond_ore";
    public static String DEEPSLATE_REDSTONE_ORE_BLOCK = "minecraft:deepslate_redstone_ore";
    public static String DEEPSLATE_EMERALD_ORE_BLOCK = "minecraft:deepslate_emerald_ore";
    public static String DEEPSLATE_COPPER_ORE_BLOCK = "minecraft:deepslate_copper_ore";
    public static String COPPER_ORE_BLOCK = "minecraft:copper_ore";
    public static String DEEPSLATE_BLOCK = "minecraft:deepslate";
    public static String NETHERRACK_BLOCK = "minecraft:netherrack";
    public static String LOG_BLOCK = "minecraft:log";
    public static String LOG2_BLOCK = "minecraft:log2";
    public static String LEAVES_BLOCK = "minecraft:leaves";
    public static String LEAVES2_BLOCK = "minecraft:leaves2";
    public static String GLASS_BLOCK = "minecraft:glass";
    public static String WOODEN_DOOR_BLOCK = "minecraft:wooden_door";
    public static String IRON_DOOR_BLOCK = "minecraft:iron_door";
    public static String SNOW_LAYER_BLOCK = "minecraft:snow_layer";
    public static String SNOW_BLOCK = "minecraft:snow";
    public static String ICE_BLOCK = "minecraft:ice";
    public static String QUARTZ_BLOCK = "minecraft:quartz_block";
    public static String WATER_BLOCK = "minecraft:water";
    public static String FLOWING_WATER_BLOCK = "minecraft:flowing_water";
    private static HashSet<String> log_blocks = new HashSet<String>(Arrays.asList(LOG_BLOCK, LOG2_BLOCK));
    private static HashSet<String> water_blocks = new HashSet<String>(Arrays.asList(WATER_BLOCK, FLOWING_WATER_BLOCK));
    public static final DynmapBlockState AIR = new DynmapBlockState(null, 0, AIR_BLOCK, "", "AIR", 0);
    private static DynmapBlockState still_water = null;

    public DynmapBlockState(DynmapBlockState base, int stateidx, String blkname, String statename, String material) {
        this(base, stateidx, blkname, statename, material, -1, -1);
    }

    public DynmapBlockState(DynmapBlockState base, int stateidx, String blkname, String statename, String material, int legacyblkid) {
        this(base, stateidx, blkname, statename, material, legacyblkid, -1);
    }

    private DynmapBlockState(DynmapBlockState base, int stateidx, String blkname, String statename, String material, int legacyblkid, int lightAtten) {
        if (blockArrayByIndex != null) {
            blockArrayByIndex = null;
            blockArrayByLegacyID = null;
            System.err.println("Error: DynmapBlockState updated after arrays generated");
            Thread.dumpStack();
        }
        this.globalStateIndex = nextGlobalStateIndex++;
        if (base == null) {
            base = this;
        }
        this.baseState = base;
        this.stateIndex = stateidx;
        this.legacyBlockID = legacyblkid;
        this.material = material;
        if (blkname.indexOf(58) == -1) {
            blkname = "minecraft:" + blkname;
        }
        this.blockName = blkname;
        String string = this.stateName = statename != null ? statename : "";
        if (base != this) {
            if (base.states == null) {
                base.states = new DynmapBlockState[Math.max((stateidx + 1) * 3 / 2, 16)];
                Arrays.fill(base.states, AIR);
                base.states[0] = base;
                base.lookup = new ConcurrentHashMap();
            } else if (base.states.length <= stateidx) {
                Object[] newstates = Arrays.copyOf(base.states, Math.max((stateidx + 1) * 3 / 2, 16));
                Arrays.fill(newstates, base.states.length, newstates.length, AIR);
                base.states = newstates;
            }
            base.states[stateidx] = this;
            base.stateLastIdx = Math.max(base.stateLastIdx, stateidx);
        }
        this.stateList = this.stateName.toLowerCase().split(",");
        if (base == this) {
            blocksByName.put(blkname, this);
            if (this.legacyBlockID >= 0) {
                blocksByLegacyID.put(this.legacyBlockID, this);
            }
        }
        this.fullName = this.stateName.length() > 0 ? this.blockName + "[" + this.stateName + "]" : this.blockName;
        blocksByIndex.put(this.globalStateIndex, this);
        this.matchflags |= this.blockName.equals(AIR_BLOCK) ? MATCH_AIR : 0;
        this.matchflags |= DynmapBlockState.isWater(this.blockName) ? MATCH_WATER : 0;
        this.matchflags |= this.blockName.equals(SNOW_BLOCK) || this.blockName.equals(SNOW_LAYER_BLOCK) ? MATCH_SNOW : 0;
        this.matchflags |= this.blockName.equals(GRASS_BLOCK) ? MATCH_GRASS : 0;
        this.matchflags |= log_blocks.contains(this.blockName) ? MATCH_LOG : 0;
        if (this.blockName.equals(WATER_BLOCK) && this == this.baseState) {
            still_water = this;
        }
        this.lightAttenuation = lightAtten;
    }

    public static void finalizeBlockStates() {
        blockArrayByIndex = new DynmapBlockState[nextGlobalStateIndex];
        Arrays.fill(blockArrayByIndex, AIR);
        for (Map.Entry<Integer, DynmapBlockState> rec : blocksByIndex.entrySet()) {
            DynmapBlockState.blockArrayByIndex[rec.getKey().intValue()] = rec.getValue();
        }
        int maxLegacyID = 0;
        for (Map.Entry<Integer, DynmapBlockState> rec : blocksByLegacyID.entrySet()) {
            maxLegacyID = Math.max(maxLegacyID, rec.getKey());
        }
        blockArrayByLegacyID = new DynmapBlockState[maxLegacyID + 1];
        for (Map.Entry<Integer, DynmapBlockState> rec : blocksByLegacyID.entrySet()) {
            DynmapBlockState.blockArrayByLegacyID[rec.getKey().intValue()] = rec.getValue();
        }
    }

    public final DynmapBlockState getStateByIndex(int idx) {
        if (this.baseState.states == null) {
            return idx == 0 ? this : null;
        }
        return idx >= 0 && idx <= this.baseState.stateLastIdx ? this.baseState.states[idx] : AIR;
    }

    public static final DynmapBlockState getBaseStateByName(String name) {
        DynmapBlockState blk = blocksByName.get(name);
        if (blk == null && name.indexOf(58) == -1 && (blk = blocksByName.get("minecraft:" + name)) == null) {
            try {
                int v = Integer.parseInt(name);
                if (v >= 0) {
                    blk = blocksByLegacyID.get(v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return blk != null ? blk : AIR;
    }

    public static final DynmapBlockState getStateByNameAndIndex(String name, int idx) {
        DynmapBlockState blk = DynmapBlockState.getBaseStateByName(name);
        if (blk != null) {
            blk = blk.getState(idx);
        }
        return blk != null ? blk : AIR;
    }

    public static final DynmapBlockState getStateByGlobalIndex(int gidx) {
        if (blockArrayByIndex != null) {
            try {
                return blockArrayByIndex[gidx];
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                return AIR;
            }
        }
        DynmapBlockState bs = blocksByIndex.get(gidx);
        return bs != null ? bs : AIR;
    }

    public static final DynmapBlockState getStateByLegacyBlockID(int legacyid) {
        if (blockArrayByLegacyID != null) {
            try {
                return blockArrayByLegacyID[legacyid];
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                return null;
            }
        }
        return blocksByLegacyID.get(legacyid);
    }

    public static final DynmapBlockState getStateByNameAndState(String name, String statename) {
        DynmapBlockState blk = DynmapBlockState.getBaseStateByName(name);
        DynmapBlockState rslt = AIR;
        if (blk != null) {
            rslt = blk;
            if (blk.states != null) {
                rslt = blk.lookup.get(statename);
                if (rslt != null) {
                    return rslt;
                }
                rslt = AIR;
                String[] statelist = statename.toLowerCase().split(",");
                for (DynmapBlockState bb : blk.states) {
                    boolean match = true;
                    for (int i = 0; i < statelist.length; ++i) {
                        boolean valmatch = false;
                        for (int j = 0; j < bb.stateList.length; ++j) {
                            if (!statelist[i].equals(bb.stateList[j])) continue;
                            valmatch = true;
                            break;
                        }
                        if (valmatch) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    rslt = bb;
                    break;
                }
                blk.lookup.put(statename, rslt);
            }
        }
        return rslt;
    }

    public static final int getGlobalIndexMax() {
        return nextGlobalStateIndex;
    }

    public final boolean isNotAir() {
        return (this.matchflags & MATCH_AIR) == 0;
    }

    public final boolean isAir() {
        return (this.matchflags & MATCH_AIR) != 0;
    }

    public final void setAir() {
        this.matchflags |= MATCH_AIR;
    }

    public final int getStateCount() {
        return this.baseState.stateLastIdx + 1;
    }

    public final DynmapBlockState getState(int idx) {
        if (this.baseState.states == null) {
            return idx == 0 ? this : AIR;
        }
        return idx <= this.baseState.stateLastIdx ? this.baseState.states[idx] : AIR;
    }

    public final boolean isLog() {
        return (this.matchflags & MATCH_LOG) != 0;
    }

    public final void setLog() {
        this.matchflags |= MATCH_LOG;
    }

    public final boolean isWater() {
        return (this.matchflags & MATCH_WATER) != 0;
    }

    public static boolean isWater(String blockname) {
        return water_blocks.contains(blockname);
    }

    public void addWaterBlock(String name) {
        water_blocks.add(name);
        DynmapBlockState bbs = DynmapBlockState.getBaseStateByName(name);
        if (bbs.isNotAir()) {
            for (int i = 0; i < bbs.getStateCount(); ++i) {
                bbs.states[i].matchflags |= MATCH_WATER;
            }
        }
    }

    public final boolean isSnow() {
        return (this.matchflags & MATCH_SNOW) != 0;
    }

    public final boolean isGrass() {
        return (this.matchflags & MATCH_GRASS) != 0;
    }

    public final boolean isWaterlogged() {
        return (this.matchflags & MATCH_WATERLOGGED) != 0;
    }

    public final void setWaterlogged() {
        this.matchflags |= MATCH_WATERLOGGED;
    }

    public final boolean isWaterFilled() {
        return (this.matchflags & (MATCH_WATERLOGGED | MATCH_WATER)) != 0;
    }

    public final boolean isLeaves() {
        return (this.matchflags & MATCH_LEAVES) != 0;
    }

    public final void setLeaves() {
        this.matchflags |= MATCH_LEAVES;
    }

    public boolean is(String blkname) {
        return this.blockName.equals(blkname);
    }

    public boolean matchingBaseState(DynmapBlockState blk) {
        return this.baseState == blk.baseState;
    }

    public DynmapBlockState getLiquidState() {
        if (this.isWaterlogged()) {
            return still_water;
        }
        return null;
    }

    public boolean isSolid() {
        return (this.matchflags & MATCH_SOLID) != 0;
    }

    public void setSolid() {
        this.matchflags |= MATCH_SOLID;
    }

    public final int getLightAttenuation() {
        if (this.lightAttenuation < 0) {
            this.lightAttenuation = this.isWater() || this.isWaterlogged() || this.isLeaves() ? 1 : 0;
        }
        return this.lightAttenuation;
    }

    public final boolean isStateMatch(String attrib, String value) {
        String v = attrib + "=" + value;
        v = v.toLowerCase();
        for (String state : this.stateList) {
            if (!state.equals(v)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.fullName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DynmapBlockState) {
            return ((DynmapBlockState)obj).globalStateIndex == this.globalStateIndex;
        }
        return false;
    }

    public int hashCode() {
        return this.globalStateIndex;
    }

    public static class Builder {
        private DynmapBlockState base;
        private int stateidx;
        private String blkname;
        private String statename;
        private String material;
        private int legacyblkid;
        private int matchflags;
        private int lightblocked;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.base = null;
            this.blkname = null;
            this.statename = null;
            this.material = null;
            this.legacyblkid = -1;
            this.matchflags = 0;
            this.lightblocked = 0;
        }

        public Builder setBaseState(DynmapBlockState blkbase) {
            this.base = blkbase;
            return this;
        }

        public Builder setStateIndex(int sidx) {
            this.stateidx = sidx;
            return this;
        }

        public Builder setBlockName(String blkname) {
            this.blkname = blkname;
            return this;
        }

        public Builder setStateName(String stname) {
            this.statename = stname;
            return this;
        }

        public Builder setMaterial(String mat) {
            this.material = mat;
            return this;
        }

        public Builder setLegacyBlockID(int legacybid) {
            this.legacyblkid = legacybid;
            return this;
        }

        public Builder setAir() {
            this.matchflags |= MATCH_AIR;
            return this;
        }

        public Builder setLog() {
            this.matchflags |= MATCH_LOG;
            return this;
        }

        public Builder setCustomWater() {
            this.matchflags |= MATCH_WATER;
            return this;
        }

        public Builder setWaterlogged() {
            this.matchflags |= MATCH_WATERLOGGED;
            return this;
        }

        public Builder setLeaves() {
            this.matchflags |= MATCH_LEAVES;
            return this;
        }

        public Builder setSolid() {
            this.matchflags |= MATCH_SOLID;
            return this;
        }

        public Builder setBlocksLight() {
            this.lightblocked = 15;
            return this;
        }

        public Builder setAttenuatesLight(int levels) {
            this.lightblocked = levels;
            return this;
        }

        public DynmapBlockState build() {
            DynmapBlockState bs = new DynmapBlockState(this.base, this.stateidx, this.blkname, this.statename, this.material, this.legacyblkid, this.lightblocked);
            if ((this.matchflags & MATCH_AIR) != 0) {
                bs.setAir();
            }
            if ((this.matchflags & MATCH_LOG) != 0) {
                bs.setLog();
            }
            if ((this.matchflags & MATCH_WATERLOGGED) != 0) {
                bs.setWaterlogged();
            }
            if ((this.matchflags & MATCH_LEAVES) != 0) {
                bs.setLeaves();
            }
            if ((this.matchflags & MATCH_SOLID) != 0) {
                bs.setSolid();
            }
            if ((this.matchflags & MATCH_WATER) != 0) {
                bs.addWaterBlock(this.blkname);
            }
            this.reset();
            return bs;
        }
    }
}

