/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class Times {
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long TICKS_PER_SECOND = 20L;
    private static final long MILLISECONDS_PER_TICK = 50L;

    public static long ticksFrom(@NotNull Duration duration) {
        return duration.toMillis() / 50L;
    }

    @NotNull
    static Duration durationFrom(long ticks) {
        return Times.durationFrom(ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    static Duration durationFrom(long duration, @NotNull TimeUnit unit) {
        return Duration.of(duration, unit.toChronoUnit());
    }

    private Times() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

