/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.ContextualPromiseBuilder;
import tr.com.infumia.task.ContextualTaskBuilder;
import tr.com.infumia.task.Internal;
import tr.com.infumia.task.Promise;
import tr.com.infumia.task.Task;
import tr.com.infumia.task.TaskBuilder;
import tr.com.infumia.task.ThreadContext;

record TaskBuilderImpl(@NotNull TaskBuilder.ThreadContextual async, @NotNull TaskBuilder.ThreadContextual sync) implements TaskBuilder
{
    static final TaskBuilder INSTANCE = new TaskBuilderImpl();

    private TaskBuilderImpl() {
        this(new ThreadContextualBuilder(ThreadContext.ASYNC), new ThreadContextualBuilder(ThreadContext.SYNC));
    }

    private record ThreadContextualBuilder(@NotNull ThreadContext context, @NotNull ContextualPromiseBuilder instant) implements TaskBuilder.ThreadContextual
    {
        private ThreadContextualBuilder(@NotNull ThreadContext context) {
            this(context, new ContextualPromiseBuilderImpl(context));
        }

        @Override
        @NotNull
        public TaskBuilder.Delayed after(@NotNull Duration duration) {
            return new DelayedBuilder(this.context, duration);
        }

        @Override
        @NotNull
        public ContextualTaskBuilder afterAndEvery(@NotNull Duration duration) {
            return new ContextualTaskBuilderImpl(this.context, duration, duration);
        }

        @Override
        @NotNull
        public ContextualTaskBuilder every(@NotNull Duration duration) {
            return new ContextualTaskBuilderImpl(this.context, Duration.ZERO, duration);
        }

        @Override
        @NotNull
        public ContextualPromiseBuilder now() {
            return this.instant;
        }
    }

    private record DelayedBuilder(@NotNull ThreadContext context, @NotNull Duration delay) implements TaskBuilder.Delayed
    {
        @Override
        @NotNull
        public <T> Promise<T> call(@NotNull Callable<T> callable) {
            return Internal.get(this.context).callLater(callable, this.delay);
        }

        @Override
        @NotNull
        public Promise<Void> run(@NotNull Runnable runnable) {
            return Internal.get(this.context).runLater(runnable, this.delay);
        }

        @Override
        @NotNull
        public <T> Promise<T> supply(@NotNull Supplier<T> supplier) {
            return Internal.get(this.context).supplyLater(supplier, this.delay);
        }

        @Override
        @NotNull
        public ContextualTaskBuilder every(@NotNull Duration duration) {
            return new ContextualTaskBuilderImpl(this.context, this.delay, duration);
        }
    }

    private record ContextualTaskBuilderImpl(@NotNull ThreadContext context, @NotNull Duration delay, @NotNull Duration interval) implements ContextualTaskBuilder
    {
        @Override
        @NotNull
        public Task consume(@NotNull Consumer<Task> consumer) {
            return Internal.get(this.context).runRepeating(consumer, this.delay, this.interval);
        }

        @Override
        @NotNull
        public Task run(@NotNull Runnable runnable) {
            return Internal.get(this.context).runRepeating(runnable, this.delay, this.interval);
        }
    }

    private record ContextualPromiseBuilderImpl(@NotNull ThreadContext context) implements ContextualPromiseBuilder
    {
        @Override
        @NotNull
        public <T> Promise<T> call(@NotNull Callable<T> callable) {
            return Internal.get(this.context).call(callable);
        }

        @Override
        @NotNull
        public Promise<Void> run(@NotNull Runnable runnable) {
            return Internal.get(this.context).run(runnable);
        }

        @Override
        @NotNull
        public <T> Promise<T> supply(@NotNull Supplier<T> supplier) {
            return Internal.get(this.context).supply(supplier);
        }
    }
}

