/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.ContextualPromiseBuilder;
import tr.com.infumia.task.ContextualTaskBuilder;
import tr.com.infumia.task.TaskBuilderImpl;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.task.Times;

public interface TaskBuilder {
    @NotNull
    public static TaskBuilder newBuilder() {
        return TaskBuilderImpl.INSTANCE;
    }

    @NotNull
    public ThreadContextual async();

    @NotNull
    default public ThreadContextual on(@NotNull ThreadContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.sync();
            case ThreadContext.ASYNC -> this.async();
        };
    }

    @NotNull
    public ThreadContextual sync();

    public static interface ThreadContextual {
        @NotNull
        default public Delayed after(long ticks) {
            return this.after(Times.durationFrom(ticks));
        }

        @NotNull
        default public Delayed after(long duration, @NotNull TimeUnit unit) {
            return this.after(Times.durationFrom(duration, unit));
        }

        @NotNull
        public Delayed after(@NotNull Duration var1);

        @NotNull
        default public ContextualTaskBuilder afterAndEvery(long ticks) {
            return this.afterAndEvery(Times.durationFrom(ticks));
        }

        @NotNull
        default public ContextualTaskBuilder afterAndEvery(long duration, @NotNull TimeUnit unit) {
            return this.afterAndEvery(Times.durationFrom(duration, unit));
        }

        @NotNull
        public ContextualTaskBuilder afterAndEvery(@NotNull Duration var1);

        @NotNull
        default public ContextualTaskBuilder every(long ticks) {
            return this.every(Times.durationFrom(ticks));
        }

        @NotNull
        default public ContextualTaskBuilder every(long duration, @NotNull TimeUnit unit) {
            return this.every(Times.durationFrom(duration, unit));
        }

        @NotNull
        public ContextualTaskBuilder every(@NotNull Duration var1);

        @NotNull
        public ContextualPromiseBuilder now();
    }

    public static interface Delayed
    extends ContextualPromiseBuilder {
        @NotNull
        default public ContextualTaskBuilder every(long ticks) {
            return this.every(Times.durationFrom(ticks));
        }

        @NotNull
        default public ContextualTaskBuilder every(long duration, @NotNull TimeUnit unit) {
            return this.every(Times.durationFrom(duration, unit));
        }

        @NotNull
        public ContextualTaskBuilder every(@NotNull Duration var1);
    }
}

