/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.Schedulers;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.terminable.Terminable;

public interface ServerThreadLock
extends Terminable {
    @NotNull
    public static ServerThreadLock obtain() {
        return new Impl();
    }

    public void close();

    public static final class Impl
    implements ServerThreadLock {
        private final CountDownLatch done = new CountDownLatch(1);
        private final CountDownLatch obtained = new CountDownLatch(1);

        private Impl() {
            if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
                this.obtained.countDown();
                return;
            }
            Schedulers.sync().run(this::signal);
            this.await();
        }

        @Override
        public void close() {
            this.done.countDown();
        }

        private void await() {
            try {
                this.obtained.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void signal() {
            this.obtained.countDown();
            try {
                this.done.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

