/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.CallableToSupplier;
import tr.com.infumia.task.ConsumerToPredicate;
import tr.com.infumia.task.Promise;
import tr.com.infumia.task.RunnableToConsumer;
import tr.com.infumia.task.Task;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.task.Times;

public interface Scheduler {
    @NotNull
    default public <T> Promise<T> call(@NotNull Callable<T> callable) {
        return this.supply(new CallableToSupplier<T>(callable));
    }

    @NotNull
    default public <T> Promise<T> callLater(@NotNull Callable<T> callable, long delayTicks) {
        return this.callLater(callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <T> Promise<T> callLater(@NotNull Callable<T> callable, long delay, @NotNull TimeUnit unit) {
        return this.callLater(callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <T> Promise<T> callLater(@NotNull Callable<T> callable, @NotNull Duration delay) {
        return this.supplyLater(new CallableToSupplier<T>(callable), delay);
    }

    @NotNull
    public ThreadContext context();

    @NotNull
    public Promise<Void> run(@NotNull Runnable var1);

    @NotNull
    default public Promise<Void> runLater(@NotNull Runnable runnable, long delayTicks) {
        return this.runLater(runnable, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> runLater(@NotNull Runnable runnable, long delay, @NotNull TimeUnit unit) {
        return this.runLater(runnable, Times.durationFrom(delay, unit));
    }

    @NotNull
    public Promise<Void> runLater(@NotNull Runnable var1, @NotNull Duration var2);

    @NotNull
    default public Task runRepeating(@NotNull Consumer<Task> taskConsumer, long delayTicks, long intervalTicks) {
        return this.runRepeating(taskConsumer, Times.durationFrom(delayTicks), Times.durationFrom(intervalTicks));
    }

    @NotNull
    default public Task runRepeating(@NotNull Consumer<Task> taskConsumer, long delay, @NotNull TimeUnit delayUnit, long interval, @NotNull TimeUnit intervalUnit) {
        return this.runRepeating(taskConsumer, Times.durationFrom(delay, delayUnit), Times.durationFrom(interval, intervalUnit));
    }

    @NotNull
    default public Task runRepeating(@NotNull Consumer<Task> taskConsumer, @NotNull Duration delay, @NotNull Duration interval) {
        return this.runRepeatingCloseIf(new ConsumerToPredicate<Task>(taskConsumer, false), delay, interval);
    }

    @NotNull
    default public Task runRepeating(@NotNull Runnable runnable, long delayTicks, long intervalTicks) {
        return this.runRepeating(runnable, Times.durationFrom(delayTicks), Times.durationFrom(intervalTicks));
    }

    @NotNull
    default public Task runRepeating(@NotNull Runnable runnable, long delay, @NotNull TimeUnit delayUnit, long interval, @NotNull TimeUnit intervalUnit) {
        return this.runRepeating(runnable, Times.durationFrom(delay, delayUnit), Times.durationFrom(interval, intervalUnit));
    }

    @NotNull
    default public Task runRepeating(@NotNull Runnable runnable, @NotNull Duration delay, @NotNull Duration interval) {
        return this.runRepeating(new RunnableToConsumer<Task>(runnable), delay, interval);
    }

    @NotNull
    default public Task runRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, long delayTicks, long intervalTicks) {
        return this.runRepeatingCloseIf(taskPredicate, Times.durationFrom(delayTicks), Times.durationFrom(intervalTicks));
    }

    @NotNull
    default public Task runRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, long delay, @NotNull TimeUnit delayUnit, long interval, @NotNull TimeUnit intervalUnit) {
        return this.runRepeatingCloseIf(taskPredicate, Times.durationFrom(delay, delayUnit), Times.durationFrom(interval, intervalUnit));
    }

    @NotNull
    public Task runRepeatingCloseIf(@NotNull Predicate<Task> var1, @NotNull Duration var2, @NotNull Duration var3);

    @NotNull
    default public Task scheduleRepeating(@NotNull Runnable task, long delayTicks, long intervalTicks) {
        return this.scheduleRepeating(task, Times.durationFrom(delayTicks), Times.durationFrom(intervalTicks));
    }

    @NotNull
    default public Task scheduleRepeating(@NotNull Runnable task, long delay, long interval, @NotNull TimeUnit unit) {
        return this.scheduleRepeating(task, Times.durationFrom(delay, unit), Times.durationFrom(interval, unit));
    }

    @NotNull
    default public Task scheduleRepeating(@NotNull Runnable task, @NotNull Duration delay, @NotNull Duration interval) {
        return this.scheduleRepeating(new RunnableToConsumer<Task>(task), delay, interval);
    }

    @NotNull
    default public Task scheduleRepeating(@NotNull Consumer<Task> taskConsumer, long delayTicks, long intervalTicks) {
        return this.scheduleRepeating(taskConsumer, Times.durationFrom(delayTicks), Times.durationFrom(intervalTicks));
    }

    @NotNull
    default public Task scheduleRepeating(@NotNull Consumer<Task> taskConsumer, long delay, long interval, @NotNull TimeUnit unit) {
        return this.scheduleRepeating(taskConsumer, Times.durationFrom(delay, unit), Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Task scheduleRepeating(@NotNull Consumer<Task> taskConsumer, @NotNull Duration delay, @NotNull Duration interval) {
        return this.scheduleRepeatingCloseIf(new ConsumerToPredicate<Task>(taskConsumer, false), delay, interval);
    }

    @NotNull
    default public Task scheduleRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, long delayTicks, long intervalTicks) {
        return this.scheduleRepeatingCloseIf(taskPredicate, Times.durationFrom(delayTicks), Times.durationFrom(intervalTicks));
    }

    @NotNull
    default public Task scheduleRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, long delay, long interval, @NotNull TimeUnit unit) {
        return this.scheduleRepeatingCloseIf(taskPredicate, Times.durationFrom(delay, unit), Times.durationFrom(delay, unit));
    }

    @NotNull
    public Task scheduleRepeatingCloseIf(@NotNull Predicate<Task> var1, @NotNull Duration var2, @NotNull Duration var3);

    @NotNull
    default public <T> Promise<T> supply(@NotNull Supplier<T> supplier) {
        return Promise.supplying(this.context(), supplier);
    }

    @NotNull
    default public <T> Promise<T> supplyLater(@NotNull Supplier<T> supplier, long delayTicks) {
        return this.supplyLater(supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <T> Promise<T> supplyLater(@NotNull Supplier<T> supplier, long delay, @NotNull TimeUnit unit) {
        return this.supplyLater(supplier, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <T> Promise<T> supplyLater(@NotNull Supplier<T> supplier, @NotNull Duration delay) {
        return Promise.supplyingDelayed(this.context(), supplier, delay);
    }
}

