/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.task.Executors;
import tr.com.infumia.task.Promise;
import tr.com.infumia.task.PromiseSupply;
import tr.com.infumia.task.PromiseThrowingSupply;

final class PromiseImpl<V>
implements Promise<V> {
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);
    @NotNull
    protected final CompletableFuture<V> future;
    protected final AtomicBoolean supplied = new AtomicBoolean(false);

    PromiseImpl() {
        this.future = new CompletableFuture();
    }

    PromiseImpl(@Nullable V value) {
        this.future = CompletableFuture.completedFuture(value);
        this.supplied.set(true);
    }

    PromiseImpl(@NotNull Throwable throwable) {
        this();
        this.future.completeExceptionally(throwable);
        this.supplied.set(true);
    }

    PromiseImpl(@NotNull CompletableFuture<V> future) {
        this.future = future;
        this.supplied.set(true);
        this.cancelled.set(future.isCancelled());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled.set(true);
        return this.future().cancel(mayInterruptIfRunning);
    }

    @Override
    @NotNull
    public PromiseImpl<V> supply(@Nullable V value) {
        this.markAsSupplied();
        this.complete(value);
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyAsync(@NotNull Supplier<V> supplier) {
        this.markAsSupplied();
        Executors.async(new PromiseSupply<V>(this, supplier));
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyDelayedAsync(@NotNull Supplier<V> supplier, @NotNull Duration delay) {
        this.markAsSupplied();
        Executors.asyncDelayed(new PromiseSupply<V>(this, supplier), delay);
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyDelayedSync(@NotNull Supplier<V> supplier, @NotNull Duration delay) {
        this.markAsSupplied();
        Executors.syncDelayed(new PromiseSupply<V>(this, supplier), delay);
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyException(@NotNull Throwable exception) {
        this.markAsSupplied();
        this.completeExceptionally(exception);
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyExceptionallyAsync(@NotNull Callable<V> callable) {
        this.markAsSupplied();
        Executors.async(new PromiseThrowingSupply<V>(this, callable));
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyExceptionallyDelayedAsync(@NotNull Callable<V> callable, @NotNull Duration delay) {
        this.markAsSupplied();
        Executors.asyncDelayed(new PromiseThrowingSupply<V>(this, callable), delay);
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyExceptionallyDelayedSync(@NotNull Callable<V> callable, @NotNull Duration delay) {
        this.markAsSupplied();
        Executors.syncDelayed(new PromiseThrowingSupply<V>(this, callable), delay);
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplyExceptionallySync(@NotNull Callable<V> callable) {
        this.markAsSupplied();
        Executors.sync(new PromiseThrowingSupply<V>(this, callable));
        return this;
    }

    @Override
    @NotNull
    public PromiseImpl<V> supplySync(@NotNull Supplier<V> supplier) {
        this.markAsSupplied();
        Executors.sync(new PromiseSupply<V>(this, supplier));
        return this;
    }

    void complete(@Nullable V value) {
        if (!this.cancelled.get()) {
            this.future().complete(value);
        }
    }

    void completeExceptionally(@NotNull Throwable ex) {
        if (!this.cancelled.get()) {
            this.future().completeExceptionally(ex);
        }
    }

    private void markAsSupplied() {
        if (this.supplied.compareAndSet(true, true)) {
            throw new IllegalStateException("Promise is already being supplied.");
        }
    }

    @Override
    @NotNull
    public CompletableFuture<V> future() {
        return this.future;
    }
}

