/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.task.ConsumerToFunction;
import tr.com.infumia.task.Executors;
import tr.com.infumia.task.PromiseApply;
import tr.com.infumia.task.PromiseCompose;
import tr.com.infumia.task.PromiseExceptionally;
import tr.com.infumia.task.PromiseImpl;
import tr.com.infumia.task.RunnableToFunction;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.task.Times;
import tr.com.infumia.terminable.Terminable;

public interface Promise<V>
extends Future<V>,
Terminable {
    @NotNull
    public static <U> Promise<U> completed(@Nullable U value) {
        return new PromiseImpl<U>(value);
    }

    @NotNull
    public static <U> Promise<U> empty() {
        return new PromiseImpl();
    }

    @NotNull
    public static <U> Promise<U> exceptionally(@NotNull Throwable exception) {
        return new PromiseImpl(exception);
    }

    @NotNull
    public static Promise<Void> start() {
        return Promise.completed(null);
    }

    @NotNull
    public static <U> Promise<U> supplying(@NotNull ThreadContext context, @NotNull Supplier<U> supplier) {
        return Promise.empty().supply(context, supplier);
    }

    @NotNull
    public static <U> Promise<U> supplyingAsync(@NotNull Supplier<U> supplier) {
        return Promise.empty().supplyAsync(supplier);
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayed(@NotNull ThreadContext context, @NotNull Supplier<U> supplier, long delayTicks) {
        return Promise.supplyingDelayed(context, supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayed(@NotNull ThreadContext context, @NotNull Supplier<U> supplier, long delay, @NotNull TimeUnit unit) {
        return Promise.supplyingDelayed(context, supplier, Times.durationFrom(delay, unit));
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayed(@NotNull ThreadContext context, @NotNull Supplier<U> supplier, @NotNull Duration delay) {
        return Promise.empty().supplyDelayed(context, supplier, delay);
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayedAsync(@NotNull Supplier<U> supplier, long delayTicks) {
        return Promise.supplyingDelayedAsync(supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayedAsync(@NotNull Supplier<U> supplier, long delay, @NotNull TimeUnit unit) {
        return Promise.supplyingDelayedAsync(supplier, Times.durationFrom(delay, unit));
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayedAsync(@NotNull Supplier<U> supplier, @NotNull Duration delay) {
        return Promise.empty().supplyDelayedAsync(supplier, delay);
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayedSync(@NotNull Supplier<U> supplier, long delayTicks) {
        return Promise.supplyingDelayedSync(supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayedSync(@NotNull Supplier<U> supplier, long delay, @NotNull TimeUnit unit) {
        return Promise.supplyingDelayedSync(supplier, Times.durationFrom(delay, unit));
    }

    @NotNull
    public static <U> Promise<U> supplyingDelayedSync(@NotNull Supplier<U> supplier, @NotNull Duration delay) {
        return Promise.empty().supplyDelayedSync(supplier, delay);
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionally(@NotNull ThreadContext context, @NotNull Callable<U> callable) {
        return Promise.empty().supplyExceptionally(context, callable);
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyAsync(@NotNull Callable<U> callable) {
        return Promise.empty().supplyExceptionallyAsync(callable);
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayed(@NotNull ThreadContext context, @NotNull Callable<U> callable, long delayTicks) {
        return Promise.supplyingExceptionallyDelayed(context, callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayed(@NotNull ThreadContext context, @NotNull Callable<U> callable, long delay, @NotNull TimeUnit unit) {
        return Promise.supplyingExceptionallyDelayed(context, callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayed(@NotNull ThreadContext context, @NotNull Callable<U> callable, @NotNull Duration delay) {
        return Promise.empty().supplyExceptionallyDelayed(context, callable, delay);
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayedAsync(@NotNull Callable<U> callable, long delayTicks) {
        return Promise.supplyingExceptionallyDelayedAsync(callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayedAsync(@NotNull Callable<U> callable, long delay, @NotNull TimeUnit unit) {
        return Promise.supplyingExceptionallyDelayedAsync(callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayedAsync(@NotNull Callable<U> callable, @NotNull Duration delay) {
        return Promise.empty().supplyExceptionallyDelayedAsync(callable, delay);
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayedSync(@NotNull Callable<U> callable, long delayTicks) {
        return Promise.supplyingExceptionallyDelayedSync(callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayedSync(@NotNull Callable<U> callable, long delay, @NotNull TimeUnit unit) {
        return Promise.supplyingExceptionallyDelayedSync(callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallyDelayedSync(@NotNull Callable<U> callable, @NotNull Duration delay) {
        return Promise.empty().supplyExceptionallyDelayedSync(callable, delay);
    }

    @NotNull
    public static <U> Promise<U> supplyingExceptionallySync(@NotNull Callable<U> callable) {
        return Promise.empty().supplyExceptionallySync(callable);
    }

    @NotNull
    public static <U> Promise<U> supplyingSync(@NotNull Supplier<U> supplier) {
        return Promise.empty().supplySync(supplier);
    }

    @NotNull
    public static <U> Promise<U> wrapFuture(@NotNull Future<U> future) {
        if (future instanceof CompletableFuture) {
            return new PromiseImpl(((CompletableFuture)future).thenApply(Function.identity()));
        }
        if (future instanceof CompletionStage) {
            return new PromiseImpl(((CompletionStage)((Object)future)).toCompletableFuture().thenApply(Function.identity()));
        }
        if (future.isDone()) {
            try {
                return Promise.completed(future.get());
            }
            catch (ExecutionException e) {
                return Promise.exceptionally(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return Promise.supplyingExceptionallyAsync(future::get);
    }

    default public boolean cancel() {
        return this.cancel(true);
    }

    default public void close() {
        this.cancel();
    }

    default public boolean closed() {
        return this.isCancelled();
    }

    @NotNull
    default public Promise<V> exceptionally(@NotNull ThreadContext context, @NotNull Function<Throwable, ? extends V> function) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.exceptionallySync(function);
            case ThreadContext.ASYNC -> this.exceptionallyAsync(function);
        };
    }

    @NotNull
    default public Promise<V> exceptionallyAsync(@NotNull Function<Throwable, ? extends V> function) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                Executors.async(new PromiseExceptionally(promise, function, (Throwable)t));
            }
        });
        return promise;
    }

    @NotNull
    default public Promise<V> exceptionallyDelayed(@NotNull ThreadContext context, @NotNull Function<Throwable, ? extends V> function, long delayTicks) {
        return this.exceptionallyDelayed(context, function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> exceptionallyDelayed(@NotNull ThreadContext context, @NotNull Function<Throwable, ? extends V> function, long delay, @NotNull TimeUnit unit) {
        return this.exceptionallyDelayed(context, function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<V> exceptionallyDelayed(@NotNull ThreadContext context, @NotNull Function<Throwable, ? extends V> function, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.exceptionallyDelayedSync(function, delay);
            case ThreadContext.ASYNC -> this.exceptionallyDelayedAsync(function, delay);
        };
    }

    @NotNull
    default public Promise<V> exceptionallyDelayedAsync(@NotNull Function<Throwable, ? extends V> function, long delayTicks) {
        return this.exceptionallyDelayedAsync(function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> exceptionallyDelayedAsync(@NotNull Function<Throwable, ? extends V> function, long delay, @NotNull TimeUnit unit) {
        return this.exceptionallyDelayedAsync(function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<V> exceptionallyDelayedAsync(@NotNull Function<Throwable, ? extends V> function, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                Executors.asyncDelayed(new PromiseExceptionally(promise, function, (Throwable)t), delay);
            }
        });
        return promise;
    }

    @NotNull
    default public Promise<V> exceptionallyDelayedSync(@NotNull Function<Throwable, ? extends V> function, long delayTicks) {
        return this.exceptionallyDelayedSync(function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> exceptionallyDelayedSync(@NotNull Function<Throwable, ? extends V> function, long delay, @NotNull TimeUnit unit) {
        return this.exceptionallyDelayedSync(function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<V> exceptionallyDelayedSync(@NotNull Function<Throwable, ? extends V> function, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                Executors.syncDelayed(new PromiseExceptionally(promise, function, (Throwable)t), delay);
            }
        });
        return promise;
    }

    @NotNull
    default public Promise<V> exceptionallySync(@NotNull Function<Throwable, ? extends V> function) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                Executors.sync(new PromiseExceptionally(promise, function, (Throwable)t));
            }
        });
        return promise;
    }

    @NotNull
    public CompletableFuture<V> future();

    @Nullable
    @Contract(value="!null -> !null")
    default public V getNow(@Nullable V valueIfAbsent) {
        return this.future().getNow(valueIfAbsent);
    }

    @Override
    default public boolean isCancelled() {
        return this.future().isCancelled();
    }

    @Override
    default public boolean isDone() {
        return this.future().isDone();
    }

    @Override
    default public V get() throws InterruptedException, ExecutionException {
        return this.future().get();
    }

    @Override
    default public V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future().get(timeout, unit);
    }

    @Nullable
    default public V join() {
        return this.future().join();
    }

    @NotNull
    public Promise<V> supply(@Nullable V var1);

    @NotNull
    default public Promise<V> supply(@NotNull ThreadContext context, @NotNull Supplier<V> supplier) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.supplySync(supplier);
            case ThreadContext.ASYNC -> this.supplyAsync(supplier);
        };
    }

    @NotNull
    public Promise<V> supplyAsync(@NotNull Supplier<V> var1);

    @NotNull
    default public Promise<V> supplyDelayed(@NotNull ThreadContext context, @NotNull Supplier<V> supplier, long delayTicks) {
        return this.supplyDelayed(context, supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> supplyDelayed(@NotNull ThreadContext context, @NotNull Supplier<V> supplier, long delay, @NotNull TimeUnit unit) {
        return this.supplyDelayed(context, supplier, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<V> supplyDelayed(@NotNull ThreadContext context, @NotNull Supplier<V> supplier, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.supplyDelayedSync(supplier, delay);
            case ThreadContext.ASYNC -> this.supplyDelayedAsync(supplier, delay);
        };
    }

    @NotNull
    default public Promise<V> supplyDelayedAsync(@NotNull Supplier<V> supplier, long delayTicks) {
        return this.supplyDelayedAsync(supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> supplyDelayedAsync(@NotNull Supplier<V> supplier, long delay, @NotNull TimeUnit unit) {
        return this.supplyDelayedAsync(supplier, Duration.of(delay, unit.toChronoUnit()));
    }

    @NotNull
    public Promise<V> supplyDelayedAsync(@NotNull Supplier<V> var1, @NotNull Duration var2);

    @NotNull
    default public Promise<V> supplyDelayedSync(@NotNull Supplier<V> supplier, long delayTicks) {
        return this.supplyDelayedSync(supplier, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> supplyDelayedSync(@NotNull Supplier<V> supplier, long delay, @NotNull TimeUnit unit) {
        return this.supplyDelayedSync(supplier, Times.durationFrom(delay, unit));
    }

    @NotNull
    public Promise<V> supplyDelayedSync(@NotNull Supplier<V> var1, @NotNull Duration var2);

    @NotNull
    public Promise<V> supplyException(@NotNull Throwable var1);

    @NotNull
    default public Promise<V> supplyExceptionally(@NotNull ThreadContext context, @NotNull Callable<V> callable) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.supplyExceptionallySync(callable);
            case ThreadContext.ASYNC -> this.supplyExceptionallyAsync(callable);
        };
    }

    @NotNull
    public Promise<V> supplyExceptionallyAsync(@NotNull Callable<V> var1);

    @NotNull
    default public Promise<V> supplyExceptionallyDelayed(@NotNull ThreadContext context, @NotNull Callable<V> callable, long delayTicks) {
        return this.supplyExceptionallyDelayed(context, callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> supplyExceptionallyDelayed(@NotNull ThreadContext context, @NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        return this.supplyExceptionallyDelayed(context, callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<V> supplyExceptionallyDelayed(@NotNull ThreadContext context, @NotNull Callable<V> callable, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.supplyExceptionallyDelayedSync(callable, delay);
            case ThreadContext.ASYNC -> this.supplyExceptionallyDelayedAsync(callable, delay);
        };
    }

    @NotNull
    default public Promise<V> supplyExceptionallyDelayedAsync(@NotNull Callable<V> callable, long delayTicks) {
        return this.supplyExceptionallyDelayedAsync(callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> supplyExceptionallyDelayedAsync(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        return this.supplyExceptionallyDelayedAsync(callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    public Promise<V> supplyExceptionallyDelayedAsync(@NotNull Callable<V> var1, @NotNull Duration var2);

    @NotNull
    default public Promise<V> supplyExceptionallyDelayedSync(@NotNull Callable<V> callable, long delayTicks) {
        return this.supplyExceptionallyDelayedSync(callable, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<V> supplyExceptionallyDelayedSync(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        return this.supplyExceptionallyDelayedSync(callable, Times.durationFrom(delay, unit));
    }

    @NotNull
    public Promise<V> supplyExceptionallyDelayedSync(@NotNull Callable<V> var1, @NotNull Duration var2);

    @NotNull
    public Promise<V> supplyExceptionallySync(@NotNull Callable<V> var1);

    @NotNull
    public Promise<V> supplySync(@NotNull Supplier<V> var1);

    @NotNull
    default public Promise<Void> thenAccept(@NotNull ThreadContext context, @NotNull Consumer<? super V> action) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenAcceptSync(action);
            case ThreadContext.ASYNC -> this.thenAcceptAsync(action);
        };
    }

    @NotNull
    default public Promise<Void> thenAcceptAsync(@NotNull Consumer<? super V> action) {
        return this.thenApplyAsync(v -> {
            action.accept((Object)v);
            return null;
        });
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayed(@NotNull ThreadContext context, @NotNull Consumer<? super V> action, long delayTicks) {
        return this.thenAcceptDelayed(context, action, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayed(@NotNull ThreadContext context, @NotNull Consumer<? super V> action, long delay, @NotNull TimeUnit unit) {
        return this.thenAcceptDelayed(context, action, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayed(@NotNull ThreadContext context, @NotNull Consumer<? super V> action, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenAcceptDelayedSync(action, delay);
            case ThreadContext.ASYNC -> this.thenAcceptDelayedAsync(action, delay);
        };
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayedAsync(@NotNull Consumer<? super V> action, long delayTicks) {
        return this.thenAcceptDelayedAsync(action, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayedAsync(@NotNull Consumer<? super V> action, long delay, @NotNull TimeUnit unit) {
        return this.thenAcceptDelayedAsync(action, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayedAsync(@NotNull Consumer<? super V> action, @NotNull Duration delay) {
        return this.thenApplyDelayedAsync(new ConsumerToFunction(action), delay);
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayedSync(@NotNull Consumer<? super V> action, long delayTicks) {
        return this.thenAcceptDelayedSync(action, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayedSync(@NotNull Consumer<? super V> action, long delay, @NotNull TimeUnit unit) {
        return this.thenAcceptDelayedSync(action, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<Void> thenAcceptDelayedSync(@NotNull Consumer<? super V> action, @NotNull Duration delay) {
        return this.thenApplyDelayedSync(new ConsumerToFunction(action), delay);
    }

    @NotNull
    default public Promise<Void> thenAcceptSync(@NotNull Consumer<? super V> action) {
        return this.thenApplySync(new ConsumerToFunction(action));
    }

    @NotNull
    default public <U> Promise<U> thenApply(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends U> function) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenApplySync(function);
            case ThreadContext.ASYNC -> this.thenApplyAsync(function);
        };
    }

    @NotNull
    default public <U> Promise<U> thenApplyAsync(@NotNull Function<? super V, ? extends U> function) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.async(new PromiseApply(promise, function, value));
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayed(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends U> function, long delayTicks) {
        return this.thenApplyDelayed(context, function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayed(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends U> function, long delay, @NotNull TimeUnit unit) {
        return this.thenApplyDelayed(context, function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayed(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends U> function, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenApplyDelayedSync(function, delay);
            case ThreadContext.ASYNC -> this.thenApplyDelayedAsync(function, delay);
        };
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayedAsync(@NotNull Function<? super V, ? extends U> function, long delayTicks) {
        return this.thenApplyDelayedAsync(function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayedAsync(@NotNull Function<? super V, ? extends U> function, long delay, @NotNull TimeUnit unit) {
        return this.thenApplyDelayedAsync(function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayedAsync(@NotNull Function<? super V, ? extends U> function, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.asyncDelayed(new PromiseApply(promise, function, value), delay);
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayedSync(@NotNull Function<? super V, ? extends U> function, long delayTicks) {
        return this.thenApplyDelayedSync(function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayedSync(@NotNull Function<? super V, ? extends U> function, long delay, @NotNull TimeUnit unit) {
        return this.thenApplyDelayedSync(function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <U> Promise<U> thenApplyDelayedSync(@NotNull Function<? super V, ? extends U> function, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.syncDelayed(new PromiseApply(promise, function, value), delay);
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenApplySync(@NotNull Function<? super V, ? extends U> function) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.sync(new PromiseApply(promise, function, value));
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenCompose(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends Promise<U>> function) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenComposeSync(function);
            case ThreadContext.ASYNC -> this.thenComposeAsync(function);
        };
    }

    @NotNull
    default public <U> Promise<U> thenComposeAsync(@NotNull Function<? super V, ? extends Promise<U>> function) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.async(new PromiseCompose(promise, function, value, false));
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedAsync(@NotNull Function<? super V, ? extends Promise<U>> function, long delayTicks) {
        return this.thenComposeDelayedAsync(function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedAsync(@NotNull Function<? super V, ? extends Promise<U>> function, long delay, @NotNull TimeUnit unit) {
        return this.thenComposeDelayedAsync(function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedAsync(@NotNull Function<? super V, ? extends Promise<U>> function, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.asyncDelayed(new PromiseCompose(promise, function, value, false), delay);
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedSync(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends Promise<U>> function, long delayTicks) {
        return this.thenComposeDelayedSync(context, function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedSync(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends Promise<U>> function, long delay, @NotNull TimeUnit unit) {
        return this.thenComposeDelayedSync(context, function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedSync(@NotNull ThreadContext context, @NotNull Function<? super V, ? extends Promise<U>> function, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenComposeDelayedSync(function, delay);
            case ThreadContext.ASYNC -> this.thenComposeDelayedAsync(function, delay);
        };
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedSync(@NotNull Function<? super V, ? extends Promise<U>> function, long delayTicks) {
        return this.thenComposeDelayedSync(function, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedSync(@NotNull Function<? super V, ? extends Promise<U>> function, long delay, @NotNull TimeUnit unit) {
        return this.thenComposeDelayedSync(function, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public <U> Promise<U> thenComposeDelayedSync(@NotNull Function<? super V, ? extends Promise<U>> function, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.syncDelayed(new PromiseCompose(promise, function, value, true), delay);
            }
        });
        return promise;
    }

    @NotNull
    default public <U> Promise<U> thenComposeSync(@NotNull Function<? super V, ? extends Promise<U>> function) {
        PromiseImpl promise = new PromiseImpl();
        this.future().whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                Executors.sync(new PromiseCompose(promise, function, value, true));
            }
        });
        return promise;
    }

    @NotNull
    default public Promise<Void> thenRun(@NotNull ThreadContext context, @NotNull Runnable action) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenRunSync(action);
            case ThreadContext.ASYNC -> this.thenRunAsync(action);
        };
    }

    @NotNull
    default public Promise<Void> thenRunAsync(@NotNull Runnable action) {
        return this.thenApplyAsync(new RunnableToFunction(action));
    }

    @NotNull
    default public Promise<Void> thenRunDelayed(@NotNull ThreadContext context, @NotNull Runnable action, long delayTicks) {
        return this.thenRunDelayed(context, action, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> thenRunDelayed(@NotNull ThreadContext context, @NotNull Runnable action, long delay, @NotNull TimeUnit unit) {
        return this.thenRunDelayed(context, action, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<Void> thenRunDelayed(@NotNull ThreadContext context, @NotNull Runnable action, @NotNull Duration delay) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> this.thenRunDelayedSync(action, delay);
            case ThreadContext.ASYNC -> this.thenRunDelayedAsync(action, delay);
        };
    }

    @NotNull
    default public Promise<Void> thenRunDelayedAsync(@NotNull Runnable action, long delayTicks) {
        return this.thenRunDelayedAsync(action, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> thenRunDelayedAsync(@NotNull Runnable action, long delay, @NotNull TimeUnit unit) {
        return this.thenRunDelayedAsync(action, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<Void> thenRunDelayedAsync(@NotNull Runnable action, @NotNull Duration delay) {
        return this.thenApplyDelayedAsync(new RunnableToFunction(action), delay);
    }

    @NotNull
    default public Promise<Void> thenRunDelayedSync(@NotNull Runnable action, long delayTicks) {
        return this.thenRunDelayedSync(action, Times.durationFrom(delayTicks));
    }

    @NotNull
    default public Promise<Void> thenRunDelayedSync(@NotNull Runnable action, long delay, @NotNull TimeUnit unit) {
        return this.thenRunDelayedSync(action, Times.durationFrom(delay, unit));
    }

    @NotNull
    default public Promise<Void> thenRunDelayedSync(@NotNull Runnable action, @NotNull Duration delay) {
        return this.thenApplyDelayedSync(new RunnableToFunction(action), delay);
    }

    @NotNull
    default public Promise<Void> thenRunSync(@NotNull Runnable action) {
        return this.thenApplySync(new RunnableToFunction(action));
    }
}

