/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.Task;

interface InternalTask
extends Task,
Runnable {
    @NotNull
    public Predicate<Task> backingTask();

    public void cancel();

    @NotNull
    public AtomicBoolean cancelled();

    default public boolean closed() {
        return this.cancelled().get();
    }

    @NotNull
    public AtomicInteger counter();

    @Override
    default public void run() {
        if (this.cancelled().get()) {
            this.cancel();
            return;
        }
        try {
            if (this.backingTask().test(this)) {
                this.cancel();
                return;
            }
            this.counter().incrementAndGet();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.cancelled().get()) {
            this.cancel();
        }
    }

    @Override
    default public boolean stop() {
        return !this.cancelled().getAndSet(true);
    }

    @Override
    default public int timesRan() {
        return this.counter().get();
    }
}

