/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.task.AsyncExecutor;
import tr.com.infumia.task.InternalTask;
import tr.com.infumia.task.Task;

final class InternalScheduledTask
implements InternalTask {
    @NotNull
    private final Predicate<Task> backingTask;
    @NotNull
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    @NotNull
    private final AtomicInteger counter = new AtomicInteger(0);
    @Nullable
    private ScheduledFuture<?> task;

    @Override
    public void cancel() {
        if (this.task == null) {
            throw new IllegalStateException("Initiate the task using #scheduleAtFixedRate(long, long, TimeUnit)");
        }
        this.task.cancel(false);
    }

    @Override
    public int id() {
        throw new UnsupportedOperationException();
    }

    void scheduleAtFixedRate(@NotNull Duration initialDelay, @NotNull Duration period) {
        if (this.task != null) {
            throw new IllegalStateException("You cannot schedule the same task twice!");
        }
        this.task = AsyncExecutor.INSTANCE.scheduleAtFixedRate(this, initialDelay.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
    }

    InternalScheduledTask(@NotNull Predicate<Task> backingTask) {
        if (backingTask == null) {
            throw new NullPointerException("backingTask is marked non-null but is null");
        }
        this.backingTask = backingTask;
    }

    @Override
    @NotNull
    public Predicate<Task> backingTask() {
        return this.backingTask;
    }

    @Override
    @NotNull
    public AtomicBoolean cancelled() {
        return this.cancelled;
    }

    @Override
    @NotNull
    public AtomicInteger counter() {
        return this.counter;
    }
}

