/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.AsyncExecutor;
import tr.com.infumia.task.Logger;
import tr.com.infumia.task.Scheduler;
import tr.com.infumia.task.SchedulerProvider;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.terminable.Terminable;

final class Internal {
    private static final AtomicReference<Logger> LOGGER = new AtomicReference();
    private static final AtomicReference<Thread> MAIN_THREAD = new AtomicReference();
    private static final AtomicReference<SchedulerProvider> SCHEDULER_PROVIDER = new AtomicReference();

    @NotNull
    static Terminable init(@NotNull SchedulerProvider schedulerProvider, @NotNull Logger logger) {
        MAIN_THREAD.set(Thread.currentThread());
        SCHEDULER_PROVIDER.set(schedulerProvider);
        LOGGER.set(logger);
        return AsyncExecutor.INSTANCE::cancelRepeatingTasks;
    }

    @NotNull
    static Scheduler async() {
        return Internal.schedulerProvider().async();
    }

    @NotNull
    static Scheduler get(@NotNull ThreadContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> Internal.sync();
            case ThreadContext.ASYNC -> Internal.sync();
        };
    }

    @NotNull
    static Logger logger() {
        return Objects.requireNonNull(LOGGER.get(), "initiate the task first!");
    }

    @NotNull
    static Thread mainThread() {
        return Objects.requireNonNull(MAIN_THREAD.get(), "initiate task first!");
    }

    @NotNull
    static Scheduler sync() {
        return Internal.schedulerProvider().sync();
    }

    @NotNull
    private static SchedulerProvider schedulerProvider() {
        return Objects.requireNonNull(SCHEDULER_PROVIDER.get(), "initiate the task first!");
    }

    private Internal() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

