/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.Schedulers;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.task.UncheckedRunnable;

final class Executors {
    static void async(@NotNull Runnable runnable) {
        if (ThreadContext.forCurrentThread() == ThreadContext.ASYNC) {
            new UncheckedRunnable(runnable).run();
        } else {
            Schedulers.async().run(runnable);
        }
    }

    static void asyncDelayed(@NotNull Runnable runnable, @NotNull Duration delay) {
        if (delay.isNegative() || delay.isZero()) {
            Executors.async(runnable);
        } else {
            Schedulers.async().runLater((Runnable)new UncheckedRunnable(runnable), delay);
        }
    }

    static void sync(@NotNull Runnable runnable) {
        if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
            new UncheckedRunnable(runnable).run();
        } else {
            Schedulers.sync().run(runnable);
        }
    }

    static void syncDelayed(@NotNull Runnable runnable, @NotNull Duration delay) {
        if (delay.isNegative() || delay.isZero()) {
            Executors.sync(runnable);
        } else {
            Schedulers.sync().runLater((Runnable)new UncheckedRunnable(runnable), delay);
        }
    }

    private Executors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

