/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.UncheckedRunnable;

final class AsyncExecutor
extends AbstractExecutorService
implements ScheduledExecutorService {
    static final AsyncExecutor INSTANCE = new AsyncExecutor();
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final Set<ScheduledFuture<?>> tasks = Collections.newSetFromMap(new WeakHashMap());
    @NotNull
    private final ScheduledExecutorService timerExecutionService;

    private AsyncExecutor() {
        this.executorService = Executors.newCachedThreadPool(AsyncExecutor.thread("task-scheduler-%d"));
        this.timerExecutionService = Executors.newSingleThreadScheduledExecutor(AsyncExecutor.thread("task-scheduler-timer"));
    }

    @NotNull
    private static ThreadFactory thread(final @NotNull String format) {
        return new ThreadFactory(){
            private final AtomicLong count = new AtomicLong();

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName(format.formatted(this.count.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.executorService.execute(new UncheckedRunnable(command));
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        return this.consumeTask(this.timerExecutionService.schedule(() -> this.executorService.execute(new UncheckedRunnable(command)), delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        return this.consumeTask(this.timerExecutionService.scheduleAtFixedRate(new FixedRateWorker(new UncheckedRunnable(command), this), initialDelay, period, unit));
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        return this.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        throw new IllegalStateException("Not shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRepeatingTasks() {
        Set<ScheduledFuture<?>> set = this.tasks;
        synchronized (set) {
            for (ScheduledFuture<?> task : this.tasks) {
                task.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ScheduledFuture<?> consumeTask(@NotNull ScheduledFuture<?> future) {
        Set<ScheduledFuture<?>> set = this.tasks;
        synchronized (set) {
            this.tasks.add(future);
        }
        return future;
    }

    private static final class FixedRateWorker
    implements Runnable {
        @NotNull
        private final Runnable delegate;
        @NotNull
        private final AsyncExecutor executor;
        @NotNull
        private final ReentrantLock lock = new ReentrantLock();
        @NotNull
        private final AtomicInteger running = new AtomicInteger(0);

        @Override
        public void run() {
            if (this.running.incrementAndGet() > 2) {
                this.running.decrementAndGet();
                return;
            }
            this.executor.executorService.execute(() -> {
                this.lock.lock();
                try {
                    this.delegate.run();
                }
                finally {
                    this.lock.unlock();
                    this.running.decrementAndGet();
                }
            });
        }

        public FixedRateWorker(@NotNull Runnable delegate, @NotNull AsyncExecutor executor) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (executor == null) {
                throw new NullPointerException("executor is marked non-null but is null");
            }
            this.delegate = delegate;
            this.executor = executor;
        }
    }
}

