/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.BukkitAsyncScheduler;
import tr.com.infumia.task.BukkitLogger;
import tr.com.infumia.task.BukkitSyncScheduler;
import tr.com.infumia.task.Internal;
import tr.com.infumia.task.Logger;
import tr.com.infumia.task.Scheduler;
import tr.com.infumia.task.SchedulerProvider;
import tr.com.infumia.terminable.Terminable;

public final class BukkitTasks {
    private static final Scheduler ASYNC_SCHEDULER = new BukkitAsyncScheduler();
    private static final AtomicReference<Plugin> PLUGIN = new AtomicReference();
    private static final Scheduler SYNC_SCHEDULER = new BukkitSyncScheduler();

    @NotNull
    public static Terminable init(@NotNull Plugin plugin) {
        Preconditions.checkState((boolean)Bukkit.getServer().isPrimaryThread(), (Object)"Please use #init(Plugin) method in a main thread!");
        PLUGIN.set(plugin);
        return Internal.init((SchedulerProvider)SchedulerProvider.of((Scheduler)ASYNC_SCHEDULER, (Scheduler)SYNC_SCHEDULER), (Logger)new BukkitLogger());
    }

    @NotNull
    static Plugin plugin() {
        return Objects.requireNonNull(PLUGIN.get(), "init task first!");
    }

    private BukkitTasks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

