/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.BukkitInternalTask;
import tr.com.infumia.task.BukkitTasks;
import tr.com.infumia.task.Promise;
import tr.com.infumia.task.PromiseImpl;
import tr.com.infumia.task.PromiseSupply;
import tr.com.infumia.task.RunnableToSupplier;
import tr.com.infumia.task.Scheduler;
import tr.com.infumia.task.Schedulers;
import tr.com.infumia.task.Task;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.task.Times;

final class BukkitSyncScheduler
implements Scheduler {
    private static final Logger log = LogManager.getLogger(BukkitSyncScheduler.class);

    @NotNull
    public ThreadContext context() {
        return ThreadContext.SYNC;
    }

    @NotNull
    public Promise<Void> run(@NotNull Runnable runnable) {
        PromiseImpl promise = new PromiseImpl();
        Plugin plugin = BukkitTasks.plugin();
        BukkitInternalTask task = new BukkitInternalTask(t -> {
            new PromiseSupply(promise, (Supplier)new RunnableToSupplier(runnable)).run();
            return false;
        });
        if (plugin.isEnabled()) {
            task.runTask(plugin);
        } else {
            log.error("Plugin attempted to register task while disabled!");
            log.error("We are going to run the task in the current thread which is {}!", (Object)Thread.currentThread());
            task.run();
        }
        return promise;
    }

    @NotNull
    public Promise<Void> runLater(@NotNull Runnable runnable, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        Plugin plugin = BukkitTasks.plugin();
        BukkitInternalTask task = new BukkitInternalTask(t -> {
            new PromiseSupply(promise, (Supplier)new RunnableToSupplier(runnable)).run();
            return false;
        });
        if (plugin.isEnabled()) {
            task.runTaskLater(plugin, Times.ticksFrom((Duration)delay));
        } else {
            log.error("Plugin attempted to register task while disabled!");
            log.error("The task won't be run because this is a repeating task!");
        }
        return promise;
    }

    @NotNull
    public Task runRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, @NotNull Duration delay, @NotNull Duration interval) {
        Plugin plugin = BukkitTasks.plugin();
        BukkitInternalTask task = new BukkitInternalTask(taskPredicate);
        if (plugin.isEnabled()) {
            task.runTaskTimer(plugin, Times.ticksFrom((Duration)delay), Times.ticksFrom((Duration)interval));
        } else {
            log.error("Plugin attempted to register task while disabled!");
            log.error("The task won't be run because this is a repeating task!");
        }
        return task;
    }

    @NotNull
    public Task scheduleRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, @NotNull Duration delay, @NotNull Duration interval) {
        log.error("Sync scheduler does not support #scheduleRepeating(Consumer<Task>, long, long, TimeUnit), using async scheduler to schedule repeating instead!");
        return Schedulers.async().scheduleRepeatingCloseIf(taskPredicate, delay, interval);
    }

    BukkitSyncScheduler() {
    }
}

