/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.task;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.task.AsyncExecutor;
import tr.com.infumia.task.BukkitInternalTask;
import tr.com.infumia.task.BukkitTasks;
import tr.com.infumia.task.InternalScheduledTask;
import tr.com.infumia.task.Promise;
import tr.com.infumia.task.PromiseImpl;
import tr.com.infumia.task.PromiseSupply;
import tr.com.infumia.task.RunnableToSupplier;
import tr.com.infumia.task.Scheduler;
import tr.com.infumia.task.Task;
import tr.com.infumia.task.ThreadContext;
import tr.com.infumia.task.Times;

final class BukkitAsyncScheduler
implements Scheduler {
    private static final Logger log = LogManager.getLogger(BukkitAsyncScheduler.class);

    @NotNull
    public ThreadContext context() {
        return ThreadContext.ASYNC;
    }

    @NotNull
    public Promise<Void> run(@NotNull Runnable runnable) {
        PromiseImpl promise = new PromiseImpl();
        AsyncExecutor.INSTANCE.execute((Runnable)new PromiseSupply(promise, (Supplier)new RunnableToSupplier(runnable)));
        return promise;
    }

    @NotNull
    public Promise<Void> runLater(@NotNull Runnable runnable, @NotNull Duration delay) {
        PromiseImpl promise = new PromiseImpl();
        AsyncExecutor.INSTANCE.schedule((Runnable)new PromiseSupply(promise, (Supplier)new RunnableToSupplier(runnable)), delay.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    @NotNull
    public Task runRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, @NotNull Duration delay, @NotNull Duration interval) {
        Plugin plugin = BukkitTasks.plugin();
        BukkitInternalTask task = new BukkitInternalTask(taskPredicate);
        if (plugin.isEnabled()) {
            task.runTaskTimerAsynchronously(plugin, Times.ticksFrom((Duration)delay), Times.ticksFrom((Duration)interval));
        } else {
            log.error("Plugin attempted to register task while disabled!");
            log.error("The task won't be run because this is a repeating task!");
        }
        return task;
    }

    @NotNull
    public Task scheduleRepeatingCloseIf(@NotNull Predicate<Task> taskPredicate, @NotNull Duration delay, @NotNull Duration interval) {
        InternalScheduledTask task = new InternalScheduledTask(taskPredicate);
        task.scheduleAtFixedRate(delay, interval);
        return task;
    }

    BukkitAsyncScheduler() {
    }
}

