/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class UpdateChecker {
    @NotNull
    private final Plugin plugin;
    private final int project;
    @NotNull
    private final String checkURL;
    @NotNull
    private String newVersion;

    public UpdateChecker(@NotNull Plugin plugin, int projectID) {
        this(plugin, projectID, "https://api.spigotmc.org/legacy/update.php?resource=" + projectID, plugin.getDescription().getVersion());
    }

    public static UpdateChecker checkAndGet(@NotNull Plugin plugin, int projectID) throws IOException {
        UpdateChecker checker = new UpdateChecker(plugin, projectID);
        checker.checkForUpdates();
        return checker;
    }

    @NotNull
    public String getResourceURL() {
        return "https://www.spigotmc.org/resources/" + this.project;
    }

    public boolean checkForUpdates() throws IOException {
        URLConnection con = new URL(this.checkURL).openConnection();
        this.newVersion = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
        return !this.plugin.getDescription().getVersion().equals(this.newVersion);
    }

    public UpdateChecker(@NotNull Plugin plugin, int project, @NotNull String checkURL, @NotNull String newVersion) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (checkURL == null) {
            throw new NullPointerException("checkURL is marked non-null but is null");
        }
        if (newVersion == null) {
            throw new NullPointerException("newVersion is marked non-null but is null");
        }
        this.plugin = plugin;
        this.project = project;
        this.checkURL = checkURL;
        this.newVersion = newVersion;
    }

    @NotNull
    public String getNewVersion() {
        return this.newVersion;
    }
}

