/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskUtilities {
    @Nullable
    private static Plugin plugin;

    @NotNull
    public static BukkitTask sync(final @NotNull Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        }.runTask(TaskUtilities.getPlugin());
    }

    @NotNull
    public static BukkitTask syncLater(long delay, final @NotNull Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        }.runTaskLater(TaskUtilities.getPlugin(), delay);
    }

    @NotNull
    public static BukkitTask syncTimer(long period, @NotNull Runnable runnable) {
        return TaskUtilities.syncTimerLater(0L, period, runnable);
    }

    @NotNull
    public static BukkitTask syncTimer(long period, @NotNull Supplier<Boolean> supplier) {
        return TaskUtilities.syncTimerLater(0L, period, supplier);
    }

    @NotNull
    public static BukkitTask syncTimerLater(long delay, long period, final @NotNull Supplier<Boolean> supplier) {
        return new BukkitRunnable(){

            public void run() {
                if (!((Boolean)supplier.get()).booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskTimer(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static <T> BukkitTask forAll(@NotNull List<T> objects, @NotNull Consumer<T> runArgument) {
        return TaskUtilities.forAll(1, objects, runArgument);
    }

    @NotNull
    public static BukkitTask syncTimerLater(long delay, long period, final @NotNull Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        }.runTaskTimer(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static <T> BukkitTask forAll(int perTick, List<T> objects, @NotNull Consumer<T> runArgument) {
        return TaskUtilities.forAll(perTick, objects, runArgument, () -> {});
    }

    @NotNull
    public static <T> BukkitTask forAll(final int perTick, final @NotNull List<T> objects, final @NotNull Consumer<T> runArgument, final @NotNull Runnable onDone) {
        return new BukkitRunnable(){
            private int current = 0;

            public void run() {
                for (int i = 0; i < perTick && this.current < objects.size(); ++i) {
                    Object object = objects.get(this.current);
                    try {
                        runArgument.accept(object);
                    }
                    catch (RuntimeException e) {
                        TaskUtilities.getPlugin().getLogger().log(Level.SEVERE, "TaskUtilities#forAll() iteration failed for object: " + object + (object != null ? " (" + object.getClass().getName() + ")" : ""), e);
                    }
                    ++this.current;
                }
                if (this.current >= objects.size()) {
                    this.cancel();
                    onDone.run();
                }
            }
        }.runTaskTimer(TaskUtilities.getPlugin(), 1L, 1L);
    }

    @NotNull
    public static BukkitTask async(final @NotNull Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        }.runTaskAsynchronously(TaskUtilities.getPlugin());
    }

    @NotNull
    public static BukkitTask asyncLater(long delay, final @NotNull Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        }.runTaskLaterAsynchronously(TaskUtilities.getPlugin(), delay);
    }

    @NotNull
    public static BukkitTask asyncTimer(long period, @NotNull Runnable runnable) {
        return TaskUtilities.asyncTimerLater(0L, period, runnable);
    }

    @NotNull
    public static BukkitTask asyncTimer(long period, @NotNull Supplier<Boolean> supplier) {
        return TaskUtilities.asyncTimerLater(0L, period, supplier);
    }

    @NotNull
    public static BukkitTask asyncTimerLater(long delay, long period, final @NotNull Supplier<Boolean> supplier) {
        return new BukkitRunnable(){

            public void run() {
                if (!((Boolean)supplier.get()).booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static BukkitTask asyncTimerLater(long delay, long period, final @NotNull Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        }.runTaskTimerAsynchronously(TaskUtilities.getPlugin(), delay, period);
    }

    public static void init(@NotNull Plugin plugin) {
        TaskUtilities.plugin = plugin;
    }

    @NotNull
    private static Plugin getPlugin() {
        return Optional.ofNullable(plugin).orElseThrow(() -> new RuntimeException("Use TaskUtilities#init(Plugin) first!"));
    }

    private TaskUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

