/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.util;

import io.github.portlek.mapentry.MapEntry;
import io.github.portlek.reflection.RefFieldExecuted;
import io.github.portlek.reflection.clazz.ClassOf;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.util.Pattern;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.kekoutil.TriConsumer;

public enum PlaceType {
    SLOTS((icon, contents, objects) -> objects.values().stream().map(o -> (List)o).forEach(slots -> slots.forEach(slot -> contents.set((int)slot, (Icon)icon))), "slots", int[].class),
    INSERT_INDEX((icon, contents, objects) -> contents.set((Integer)objects.get("index"), (Icon)icon), "index", Integer.TYPE),
    INSERT((icon, contents, objects) -> contents.set((Integer)objects.get("row"), (Integer)objects.get("column"), (Icon)icon), "row", Integer.TYPE, "column", Integer.TYPE),
    FILL((icon, contents, objects) -> contents.fill((Icon)icon), new Object[0]),
    FILL_EMPTIES((icon, contents, objects) -> contents.fillEmpties((Icon)icon), new Object[0]),
    FILL_ROW((icon, contents, objects) -> contents.fillRow((Integer)objects.get("row"), (Icon)icon), "row", Integer.TYPE),
    FILL_COLUMN((icon, contents, objects) -> contents.fillColumn((Integer)objects.get("column"), (Icon)icon), "column", Integer.TYPE),
    FILL_BORDERS((icon, contents, objects) -> contents.fillBorders((Icon)icon), new Object[0]),
    FILL_RECT_INDEX((icon, contents, objects) -> contents.fillRect((Integer)objects.get("from-index"), (Integer)objects.get("to-index"), (Icon)icon), "from-index", Integer.TYPE, "to-index", Integer.TYPE),
    FILL_RECT_FROM_TO((icon, contents, objects) -> contents.fillRect((Integer)objects.get("from-row"), (Integer)objects.get("from-column"), (Integer)objects.get("to-row"), (Integer)objects.get("to-column"), (Icon)icon), "from-row", Integer.TYPE, "from-column", Integer.TYPE, "to-row", Integer.TYPE, "to-column", Integer.TYPE),
    FILL_SQUARE_INDEX((icon, contents, objects) -> contents.fillSquare((Integer)objects.get("from-index"), (Integer)objects.get("to-index"), (Icon)icon), "from-index", Integer.TYPE, "to-index", Integer.TYPE),
    FILL_SQUARE_FROM_TO((icon, contents, objects) -> contents.fillSquare((Integer)objects.get("from-row"), (Integer)objects.get("from-column"), (Integer)objects.get("to-row"), (Integer)objects.get("to-column"), (Icon)icon), "from-row", Integer.TYPE, "from-column", Integer.TYPE, "to-row", Integer.TYPE, "to-column", Integer.TYPE),
    FILL_PATTERN((icon, contents, objects) -> contents.fillPattern(new Pattern<Icon>((Boolean)objects.get("wrap-around"), (String[])objects.get("pattern"))), "wrap-around", Boolean.TYPE, "pattern", String[].class),
    FILL_PATTERN_START_INDEX((icon, contents, objects) -> contents.fillPattern(new Pattern<Icon>((Boolean)objects.get("wrap-around"), (String[])objects.get("pattern")), (Integer)objects.get("start-index")), "wrap-around", Boolean.TYPE, "pattern", String[].class, "start-index", Integer.TYPE),
    FILL_PATTERN_START((icon, contents, objects) -> contents.fillPattern(new Pattern<Icon>((Boolean)objects.get("wrap-around"), (String[])objects.get("pattern")), (Integer)objects.get("start-row"), (Integer)objects.get("start-column")), "wrap-around", Boolean.TYPE, "pattern", String[].class, "start-row", Integer.TYPE, "start-column", Integer.TYPE),
    FILL_REPEATING_PATTERN((icon, contents, objects) -> contents.fillPatternRepeating(new Pattern<Icon>((Boolean)objects.get("wrap-around"), (String[])objects.get("pattern"))), "wrap-around", Boolean.TYPE, "pattern", String[].class),
    FILL_REPEATING_PATTERN_START_INDEX((icon, contents, objects) -> contents.fillPatternRepeating(new Pattern<Icon>((Boolean)objects.get("wrap-around"), (String[])objects.get("pattern")), (Integer)objects.get("start-index"), (Integer)objects.get("end-index")), "wrap-around", Boolean.TYPE, "pattern", String[].class, "start-index", Integer.TYPE, "end-index", Integer.TYPE),
    FILL_REPEATING_PATTERN_START((icon, contents, objects) -> contents.fillPatternRepeating(new Pattern<Icon>((Boolean)objects.get("wrap-around"), (String[])objects.get("pattern")), (Integer)objects.get("start-row"), (Integer)objects.get("start-column"), (Integer)objects.get("end-row"), (Integer)objects.get("end-column")), "wrap-around", Boolean.TYPE, "pattern", String[].class, "start-row", Integer.TYPE, "start-column", Integer.TYPE, "end-row", Integer.TYPE, "end-column", Integer.TYPE),
    NONE((left, middle, right) -> {}, new Object[0]);

    @NotNull
    private final TriConsumer<Icon, InventoryContents, Map<String, Object>> consumer;
    @NotNull
    private final Map<String, Class<?>> keyAndTypes;

    private PlaceType(TriConsumer<Icon, InventoryContents, Map<String, Object>> consumer, Object ... objects) {
        this(consumer, PlaceType.parse(objects));
    }

    @NotNull
    public static PlaceType fromString(@NotNull String type) {
        return Arrays.stream(PlaceType.values()).filter(placeType -> placeType.name().trim().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(type.trim().toLowerCase(Locale.ENGLISH))).findFirst().orElse(NONE);
    }

    @NotNull
    public static <T> Map<String, T> parse(Object ... objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isKey = true;
        String previousKey = "";
        for (Object object : objects) {
            if (isKey) {
                isKey = false;
                previousKey = (String)object;
                continue;
            }
            isKey = true;
            map.put(previousKey, object);
        }
        return map;
    }

    @NotNull
    private static Object def(@NotNull Class<?> type) {
        if (type.equals(Integer.class)) {
            return 1;
        }
        if (type.equals(String.class)) {
            return "test";
        }
        if (type.equals(String[].class)) {
            return new String[]{"element-1", "element-2"};
        }
        if (type.equals(int[].class)) {
            return new int[]{0, 1, 2};
        }
        if (type.equals(Boolean.TYPE)) {
            return true;
        }
        return "empty";
    }

    public boolean control(@NotNull Map<String, Object> objects) {
        if (this == SLOTS) {
            return objects.isEmpty() || objects.values().stream().allMatch(o -> Number.class.isAssignableFrom(o.getClass()));
        }
        if (objects.size() != this.keyAndTypes.size()) {
            return false;
        }
        if (objects.isEmpty()) {
            return true;
        }
        return this.keyAndTypes.entrySet().stream().allMatch(entry -> {
            Object o = objects.get(entry.getKey());
            if (o == null) {
                return false;
            }
            Class<?> aClass = o.getClass();
            return new ClassOf(aClass).field("TYPE").map(refField -> refField.of(o)).map(RefFieldExecuted::get).filter(Optional::isPresent).map(Optional::get).map(o1 -> o1.equals(entry.getValue())).orElse(aClass.equals(entry.getValue()));
        });
    }

    public void place(@NotNull Icon icon, @NotNull InventoryContents contents, @NotNull Map<String, Object> objects) {
        this.consumer.accept(icon, contents, objects);
    }

    @NotNull
    public Map<String, Object> defaultValues() {
        return this.keyAndTypes.entrySet().stream().map(entry -> MapEntry.from(entry.getKey(), PlaceType.def((Class)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private PlaceType(TriConsumer<Icon, InventoryContents, Map<String, Object>> consumer, Map<String, Class<?>> keyAndTypes) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (keyAndTypes == null) {
            throw new NullPointerException("keyAndTypes is marked non-null but is null");
        }
        this.consumer = consumer;
        this.keyAndTypes = keyAndTypes;
    }
}

