/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.util;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class ListenerUtilities {
    public static <T extends Event> void register(@NotNull Class<T> tClass, @NotNull Predicate<T> predicate, @NotNull Consumer<T> consumer, @NotNull Plugin plugin) {
        ListenerUtilities.register(tClass, predicate, consumer, EventPriority.NORMAL, plugin);
    }

    public static <T extends Event> void register(@NotNull Class<T> tClass, @NotNull EventPriority eventPriority, @NotNull Consumer<T> consumer, @NotNull Plugin plugin) {
        ListenerUtilities.register(tClass, t -> true, consumer, eventPriority, plugin);
    }

    public static <T extends Event> void register(@NotNull Class<T> tClass, @NotNull Consumer<T> consumer, @NotNull Plugin plugin) {
        ListenerUtilities.register(tClass, t -> true, consumer, EventPriority.NORMAL, plugin);
    }

    public static <T extends Event> void register(@NotNull Class<T> tClass, @NotNull Predicate<T> predicate, @NotNull Consumer<T> consumer, @NotNull EventPriority priority, @NotNull Plugin plugin) {
        Bukkit.getServer().getPluginManager().registerEvent(tClass, new Listener(){}, priority, (listener, event) -> {
            if (event.getClass().equals(tClass) && predicate.test(event)) {
                consumer.accept(event);
            }
        }, plugin);
    }

    private ListenerUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

