/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.provider;

import io.github.portlek.configs.CfgSection;
import io.github.portlek.configs.Provided;
import io.github.portlek.configs.bukkit.BkktSection;
import io.github.portlek.configs.util.GeneralUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.kekoutil.FileElement;
import tr.com.infumia.kekoutil.util.PlaceType;

public final class FileElementProvider
implements Provided<FileElement> {
    @Override
    public void set(@NotNull FileElement fileElement, @NotNull CfgSection section, @NotNull String path) {
        String dot = GeneralUtilities.putDot(path);
        ((BkktSection)section).setItemStack(dot + "item", fileElement.itemStack());
        section.set(dot + "type", fileElement.type().name());
        section.remove(dot + "values");
        fileElement.values().forEach((s, o) -> section.set(dot + "values." + s, o));
    }

    @Override
    @NotNull
    public Optional<FileElement> getWithField(@NotNull FileElement fileElement, @NotNull CfgSection section, @NotNull String path) {
        return this.get(section, path).map(element -> element.changeEvent(fileElement.events()));
    }

    @Override
    @NotNull
    public Optional<FileElement> get(@NotNull CfgSection section, @NotNull String path) {
        Map values;
        String dot = GeneralUtilities.putDot(path);
        Optional<ItemStack> itemStackOptional = ((BkktSection)section).getItemStack(dot + "item");
        Optional<String> typeOptional = section.getString(dot + "type");
        if (!itemStackOptional.isPresent() || !typeOptional.isPresent()) {
            return Optional.empty();
        }
        PlaceType type = PlaceType.fromString(typeOptional.get());
        if (type.control(values = (Map)section.getSection(dot + "values").map(CfgSection::getConfigurationSection).map(configurationSection -> configurationSection.getMapValues(false)).orElse(new HashMap()))) {
            return Optional.of(FileElement.from(itemStackOptional.get(), type, (Map<String, Object>)values, new Consumer[0]));
        }
        Map<String, Object> defaults = type.defaultValues();
        if (defaults.isEmpty()) {
            section.remove(dot + "values");
        } else {
            defaults.forEach((s, o) -> section.set(dot + "values." + s, o));
        }
        return Optional.empty();
    }
}

