/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.hooks;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.kekoutil.Hook;
import tr.com.infumia.kekoutil.Wrapped;
import tr.com.infumia.kekoutil.hooks.VaultWrapper;

public final class VaultHook
implements Hook {
    public static final String VAULT_ID = "Vault";
    @Nullable
    private Economy economy;

    @Override
    @NotNull
    public String id() {
        return VAULT_ID;
    }

    @Override
    public boolean initiate() {
        if (Bukkit.getPluginManager().getPlugin(VAULT_ID) == null) {
            return false;
        }
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }

    @Override
    @NotNull
    public Wrapped create() {
        if (this.economy == null) {
            throw new IllegalStateException("Vault not initiated! Use VaultHook#initiate() method.");
        }
        return new VaultWrapper(this.economy);
    }
}

