/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.hooks;

import java.util.ArrayList;
import java.util.Optional;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.kekoutil.GroupWrapped;

public final class LuckPermsWrapper
implements GroupWrapped {
    @NotNull
    private final LuckPerms luckPerms;

    @Override
    @NotNull
    public Optional<String> getGroup(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(User::getPrimaryGroup);
    }

    @Override
    @NotNull
    public Optional<String> getUserPrefix(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).filter(nodes -> !nodes.isEmpty()).map(nodes -> ((PrefixNode)nodes.get(0)).getMetaValue());
    }

    @Override
    @NotNull
    public Optional<String> getUserSuffix(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).filter(nodes -> !nodes.isEmpty()).map(nodes -> ((SuffixNode)nodes.get(0)).getMetaValue());
    }

    @Override
    @NotNull
    public Optional<String> getGroupPrefix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).filter(nodes -> !nodes.isEmpty()).map(nodes -> ((PrefixNode)nodes.get(0)).getMetaValue());
    }

    @Override
    @NotNull
    public Optional<String> getGroupSuffix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).filter(nodes -> !nodes.isEmpty()).map(nodes -> ((SuffixNode)nodes.get(0)).getMetaValue());
    }

    public LuckPermsWrapper(@NotNull LuckPerms luckPerms) {
        if (luckPerms == null) {
            throw new NullPointerException("luckPerms is marked non-null but is null");
        }
        this.luckPerms = luckPerms;
    }
}

