/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.hooks;

import io.github.portlek.bukkititembuilder.util.ColorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.kekoutil.Hook;
import tr.com.infumia.kekoutil.Wrapped;
import tr.com.infumia.kekoutil.hooks.ASkyBlockHook;
import tr.com.infumia.kekoutil.hooks.ASkyBlockWrapper;
import tr.com.infumia.kekoutil.hooks.BentoBoxHook;
import tr.com.infumia.kekoutil.hooks.BentoBoxWrapper;
import tr.com.infumia.kekoutil.hooks.FabledSkyblockHook;
import tr.com.infumia.kekoutil.hooks.FabledSkyblockWrapper;
import tr.com.infumia.kekoutil.hooks.GroupManagerHook;
import tr.com.infumia.kekoutil.hooks.GroupManagerWrapper;
import tr.com.infumia.kekoutil.hooks.LuckPermsHook;
import tr.com.infumia.kekoutil.hooks.LuckPermsWrapper;
import tr.com.infumia.kekoutil.hooks.PermissionsExHook;
import tr.com.infumia.kekoutil.hooks.PermissionsExWrapper;
import tr.com.infumia.kekoutil.hooks.PlaceholderAPIHook;
import tr.com.infumia.kekoutil.hooks.PlaceholderAPIWrapper;
import tr.com.infumia.kekoutil.hooks.VaultHook;
import tr.com.infumia.kekoutil.hooks.VaultWrapper;

public final class Hooks {
    private static final Map<String, Wrapped> WRAPPERS = new HashMap<String, Wrapped>();

    @NotNull
    public static Optional<VaultWrapper> getVault() {
        return Hooks.getWrapper("Vault");
    }

    @NotNull
    public static Optional<PlaceholderAPIWrapper> getPlaceholderAPI() {
        return Hooks.getWrapper("PlaceholderAPI");
    }

    @NotNull
    public static Optional<LuckPermsWrapper> getLuckPerms() {
        return Hooks.getWrapper("LuckPerms");
    }

    @NotNull
    public static Optional<ASkyBlockWrapper> getASkyBlock() {
        return Hooks.getWrapper("ASkyBlock");
    }

    @NotNull
    public static Optional<BentoBoxWrapper> getBentoBox() {
        return Hooks.getWrapper("BentoBox");
    }

    @NotNull
    public static Optional<FabledSkyblockWrapper> getFabledSkyblock() {
        return Hooks.getWrapper("FabledSkyblock");
    }

    @NotNull
    public static Optional<GroupManagerWrapper> getGroupManager() {
        return Hooks.getWrapper("GroupManager");
    }

    @NotNull
    public static Optional<PermissionsExWrapper> getPermissionsEx() {
        return Hooks.getWrapper("PermissionsEx");
    }

    public static void loadHooks() {
        Stream.of(new LuckPermsHook(), new PlaceholderAPIHook(), new VaultHook(), new ASkyBlockHook(), new BentoBoxHook(), new FabledSkyblockHook(), new GroupManagerHook(), new PermissionsExHook()).filter(Hook::initiate).forEach(hook -> WRAPPERS.put(hook.id(), hook.create()));
        WRAPPERS.keySet().forEach(Hooks::sendHookNotify);
    }

    @NotNull
    private static <T extends Wrapped> Optional<T> getWrapper(@NotNull String wrappedId) {
        return Optional.ofNullable(WRAPPERS.get(wrappedId)).map(o -> o);
    }

    private static void sendHookNotify(@NotNull String id) {
        Bukkit.getConsoleSender().sendMessage(ColorUtil.colored(id + " is hooking"));
    }

    private Hooks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

