/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.hooks;

import java.util.Optional;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.kekoutil.GroupWrapped;

public final class GroupManagerWrapper
implements GroupWrapped {
    @NotNull
    private final GroupManager groupManager;

    public GroupManagerWrapper(@NotNull GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    @NotNull
    public Optional<String> getGroup(@NotNull Player player) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(player)).map(handler -> handler.getGroup(player.getName()));
    }

    @Override
    @NotNull
    public Optional<String> getUserPrefix(@NotNull Player player) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(player)).map(handler -> handler.getUserPrefix(player.getUniqueId().toString()));
    }

    @Override
    @NotNull
    public Optional<String> getUserSuffix(@NotNull Player player) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(player)).map(handler -> handler.getUserSuffix(player.getUniqueId().toString()));
    }

    @Override
    @NotNull
    public Optional<String> getGroupPrefix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(world)).map(handler -> handler.getGroupPrefix(group));
    }

    @Override
    @NotNull
    public Optional<String> getGroupSuffix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(world)).map(handler -> handler.getGroupSuffix(group));
    }
}

