/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil.hooks;

import com.wasteofplastic.askyblock.ASkyBlock;
import com.wasteofplastic.askyblock.ASkyBlockAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.kekoutil.IslandWrapped;

public final class ASkyBlockWrapper
implements IslandWrapped {
    private static final Map<Plugin, Boolean> CACHE = new HashMap<Plugin, Boolean>();
    @NotNull
    private final ASkyBlockAPI skyBlockAPI;

    public ASkyBlockWrapper(@NotNull ASkyBlockAPI skyBlockAPI) {
        this.skyBlockAPI = skyBlockAPI;
    }

    public static boolean isKekoUtil(@NotNull Plugin plugin) {
        return CACHE.getOrDefault(plugin, false);
    }

    public static void setKekoUtil(@NotNull Plugin plugin, boolean kekoUtil) {
        CACHE.put(plugin, kekoUtil);
    }

    @Override
    public long getIslandLevel(@NotNull UUID uuid) {
        return this.skyBlockAPI.getLongIslandLevel(uuid);
    }

    @Override
    public void removeIslandLevel(@NotNull Plugin plugin, @NotNull UUID uuid, long level) {
        this.setIslandLevel(plugin, uuid, Math.max(0L, this.getIslandLevel(uuid) - level));
    }

    @Override
    public void addIslandLevel(@NotNull Plugin plugin, @NotNull UUID uuid, long level) {
        this.setIslandLevel(plugin, uuid, this.getIslandLevel(uuid) + level);
    }

    @Override
    public void setIslandLevel(@NotNull Plugin plugin, @NotNull UUID uuid, long level) {
        if (!ASkyBlockWrapper.isKekoUtil(plugin)) {
            ASkyBlockWrapper.setKekoUtil(plugin, true);
            this.skyBlockAPI.calculateIslandLevel(uuid);
        }
        ASkyBlock.getPlugin().getPlayers().setIslandLevel(uuid, level);
    }
}

