/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.kekoutil;

import io.github.portlek.bukkititembuilder.util.ColorUtil;
import io.github.portlek.smartinventory.SmartInventory;
import java.io.IOException;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.kekoutil.util.UpdateChecker;

public abstract class KekoUtil
extends JavaPlugin {
    private static final Object LOCK = new Object();
    @Nullable
    private static KekoUtil instance;
    @Nullable
    private static SmartInventory inventory;

    @NotNull
    public static KekoUtil getInstance() {
        return Optional.ofNullable(instance).orElseThrow(() -> new IllegalStateException("You cannot be used KekoUtil plugin before its start!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(@NotNull KekoUtil instance) {
        if (Optional.ofNullable(KekoUtil.instance).isPresent()) {
            throw new IllegalStateException("You can't use KekoUtil#setInstance method twice!");
        }
        Object object = LOCK;
        synchronized (object) {
            KekoUtil.instance = instance;
        }
    }

    @NotNull
    public static SmartInventory getInventory() {
        return Optional.ofNullable(inventory).orElseThrow(() -> new IllegalStateException("You cannot be used KekoUtil plugin before its start!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInventory(@NotNull SmartInventory inventory) {
        if (Optional.ofNullable(KekoUtil.inventory).isPresent()) {
            throw new IllegalStateException("You can't use KekoUtil#setInstance method twice!");
        }
        Object object = LOCK;
        synchronized (object) {
            KekoUtil.inventory = inventory;
        }
    }

    public static void checkForUpdate(@NotNull Plugin plugin) {
        KekoUtil.checkForUpdate(plugin, (CommandSender)Bukkit.getConsoleSender());
    }

    public static void checkForUpdate(@NotNull Plugin plugin, @NotNull CommandSender sender) {
        UpdateChecker updater = new UpdateChecker(plugin, 82718);
        try {
            if (updater.checkForUpdates()) {
                sender.sendMessage(ColorUtil.colored("&6[&eKekoUtil&6] &eNew version found (v" + updater.getNewVersion() + ')'));
                sender.sendMessage(ColorUtil.colored("&6[&eKekoUtil&6] &eYou can download the latest version here:"));
                sender.sendMessage(updater.getResourceURL());
            } else {
                sender.sendMessage(ColorUtil.colored("&6[&eKekoUtil&6] &aYou're using the latest version (v" + updater.getNewVersion() + ')'));
            }
        }
        catch (IOException exception) {
            plugin.getLogger().warning("Update checker failed, could not connect to the API.");
        }
    }

    protected void checkForUpdate() {
        KekoUtil.checkForUpdate((Plugin)this);
    }

    protected void checkForUpdate(@NotNull CommandSender sender) {
        KekoUtil.checkForUpdate((Plugin)this, sender);
    }
}

