/*
 * Decompiled with CFR 0.152.
 */
package net.wesjd.anvilgui;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.wesjd.anvilgui.version.VersionMatcher;
import net.wesjd.anvilgui.version.VersionWrapper;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnvilGUI {
    private static VersionWrapper WRAPPER = new VersionMatcher().match();
    private final Plugin plugin;
    private final Player player;
    private String inventoryTitle;
    private ItemStack insert;
    private final boolean preventClose;
    private final Consumer<Player> closeListener;
    private final BiFunction<Player, String, Response> completeFunction;
    private int containerId;
    private Inventory inventory;
    private final ListenUp listener = new ListenUp();
    private boolean open;

    @Deprecated
    public AnvilGUI(Plugin plugin, Player holder, String insert, BiFunction<Player, String, String> biFunction) {
        this(plugin, holder, "Repair & Name", insert, null, false, null, (player, text) -> {
            String response = (String)biFunction.apply((Player)player, (String)text);
            if (response != null) {
                return Response.text(response);
            }
            return Response.close();
        });
    }

    private AnvilGUI(Plugin plugin, Player player, String inventoryTitle, String itemText, ItemStack insert, boolean preventClose, Consumer<Player> closeListener, BiFunction<Player, String, Response> completeFunction) {
        this.plugin = plugin;
        this.player = player;
        this.inventoryTitle = inventoryTitle;
        this.insert = insert;
        this.preventClose = preventClose;
        this.closeListener = closeListener;
        this.completeFunction = completeFunction;
        if (itemText != null) {
            if (insert == null) {
                this.insert = new ItemStack(Material.PAPER);
            }
            ItemMeta paperMeta = this.insert.getItemMeta();
            paperMeta.setDisplayName(itemText);
            this.insert.setItemMeta(paperMeta);
        }
        this.openInventory();
    }

    private void openInventory() {
        WRAPPER.handleInventoryCloseEvent(this.player);
        WRAPPER.setActiveContainerDefault(this.player);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        Object container = WRAPPER.newContainerAnvil(this.player, this.inventoryTitle);
        this.inventory = WRAPPER.toBukkitInventory(container);
        this.inventory.setItem(0, this.insert);
        this.containerId = WRAPPER.getNextContainerId(this.player, container);
        WRAPPER.sendPacketOpenWindow(this.player, this.containerId, this.inventoryTitle);
        WRAPPER.setActiveContainer(this.player, container);
        WRAPPER.setActiveContainerId(container, this.containerId);
        WRAPPER.addActiveContainerSlotListener(container, this.player);
        this.open = true;
    }

    public void closeInventory() {
        if (!this.open) {
            return;
        }
        this.open = false;
        WRAPPER.handleInventoryCloseEvent(this.player);
        WRAPPER.setActiveContainerDefault(this.player);
        WRAPPER.sendPacketCloseWindow(this.player, this.containerId);
        HandlerList.unregisterAll((Listener)this.listener);
        if (this.closeListener != null) {
            this.closeListener.accept(this.player);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static class Slot {
        private static final int[] values = new int[]{0, 1, 2};
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;

        public static int[] values() {
            return values;
        }
    }

    public static class Response {
        private final String text;

        private Response(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Response close() {
            return new Response(null);
        }

        public static Response text(String text) {
            return new Response(text);
        }
    }

    public static class Builder {
        private Consumer<Player> closeListener;
        private boolean preventClose = false;
        private BiFunction<Player, String, Response> completeFunction;
        private Plugin plugin;
        private String title = "Repair & Name";
        private String itemText = "";
        private ItemStack item;

        public Builder preventClose() {
            this.preventClose = true;
            return this;
        }

        public Builder onClose(Consumer<Player> closeListener) {
            Validate.notNull(closeListener, (String)"closeListener cannot be null");
            this.closeListener = closeListener;
            return this;
        }

        public Builder onComplete(BiFunction<Player, String, Response> completeFunction) {
            Validate.notNull(completeFunction, (String)"Complete function cannot be null");
            this.completeFunction = completeFunction;
            return this;
        }

        public Builder plugin(Plugin plugin) {
            Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
            this.plugin = plugin;
            return this;
        }

        public Builder text(String text) {
            Validate.notNull((Object)text, (String)"Text cannot be null");
            this.itemText = text;
            return this;
        }

        public Builder title(String title) {
            Validate.notNull((Object)title, (String)"title cannot be null");
            this.title = title;
            return this;
        }

        public Builder item(ItemStack item) {
            Validate.notNull((Object)item, (String)"item cannot be null");
            this.item = item;
            return this;
        }

        public AnvilGUI open(Player player) {
            Validate.notNull((Object)this.plugin, (String)"Plugin cannot be null");
            Validate.notNull(this.completeFunction, (String)"Complete function cannot be null");
            Validate.notNull((Object)player, (String)"Player cannot be null");
            return new AnvilGUI(this.plugin, player, this.title, this.itemText, this.item, this.preventClose, this.closeListener, this.completeFunction);
        }
    }

    private class ListenUp
    implements Listener {
        private ListenUp() {
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent event) {
            if (event.getInventory().equals(AnvilGUI.this.inventory) && (event.getRawSlot() < 3 || event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || event.getRawSlot() < 3 && (event.getAction().equals((Object)InventoryAction.PLACE_ALL) || event.getAction().equals((Object)InventoryAction.PLACE_ONE) || event.getAction().equals((Object)InventoryAction.PLACE_SOME) || event.getCursor() != null))) {
                event.setCancelled(true);
                Player clicker = (Player)event.getWhoClicked();
                if (event.getRawSlot() == 2) {
                    ItemStack clicked = AnvilGUI.this.inventory.getItem(2);
                    if (clicked == null || clicked.getType() == Material.AIR) {
                        return;
                    }
                    Response response = (Response)AnvilGUI.this.completeFunction.apply(clicker, clicked.hasItemMeta() ? clicked.getItemMeta().getDisplayName() : "");
                    if (response.getText() != null) {
                        ItemMeta meta = clicked.getItemMeta();
                        meta.setDisplayName(response.getText());
                        clicked.setItemMeta(meta);
                        AnvilGUI.this.inventory.setItem(0, clicked);
                    } else {
                        AnvilGUI.this.closeInventory();
                    }
                }
            }
        }

        @EventHandler
        public void onInventoryDrag(InventoryDragEvent event) {
            if (event.getInventory().equals(AnvilGUI.this.inventory)) {
                for (int slot : Slot.values()) {
                    if (!event.getRawSlots().contains(slot)) continue;
                    event.setCancelled(true);
                    break;
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (AnvilGUI.this.open && event.getInventory().equals(AnvilGUI.this.inventory)) {
                AnvilGUI.this.closeInventory();
                if (AnvilGUI.this.preventClose) {
                    Bukkit.getScheduler().runTask(AnvilGUI.this.plugin, () -> AnvilGUI.this.openInventory());
                }
            }
        }
    }
}

