/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.PgCloseEvent;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public final class InventoryCloseListener
implements Listener {
    @NotNull
    private final SmartInventory inventory;

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity human = event.getPlayer();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        Optional<InventoryContents> optional = this.inventory.getContents(player);
        if (!optional.isPresent()) {
            return;
        }
        InventoryContents contents = optional.get();
        Page page = contents.page();
        PgCloseEvent close = new PgCloseEvent(contents);
        page.accept(close);
        if (!page.canClose(close)) {
            Bukkit.getScheduler().runTask(this.inventory.getPlugin(), () -> player.openInventory(event.getInventory()));
            return;
        }
        event.getInventory().clear();
        this.inventory.stopTick(player);
        this.inventory.removePage(player);
        this.inventory.removeContent(player);
        new HashMap<Inventory, InventoryContents>(this.inventory.getContentsByInventory()).forEach((inventory1, contents1) -> {
            if (contents.equals(contents1)) {
                this.inventory.removeContentByInventory((Inventory)inventory1);
            }
        });
    }

    public InventoryCloseListener(@NotNull SmartInventory inventory) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        this.inventory = inventory;
    }
}

