/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.icon;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.IconEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class BasicIcon
implements Icon {
    private final Collection<Target<? extends IconEvent>> targets = new ArrayList<Target<? extends IconEvent>>();
    @NotNull
    private final ItemStack item;
    @NotNull
    private Predicate<InventoryContents> canSee = contents -> true;
    @NotNull
    private Predicate<InventoryContents> canUse = contents -> true;
    @NotNull
    private ItemStack fallback = new ItemStack(Material.AIR);

    @Override
    @NotNull
    public ItemStack calculateItem() {
        return this.item;
    }

    @Override
    @NotNull
    public ItemStack calculateItem(@NotNull InventoryContents contents) {
        ItemStack calculated = this.canSee.test(contents) ? this.item : this.fallback;
        return calculated;
    }

    @Override
    public <T extends IconEvent> void accept(@NotNull T event) {
        InventoryContents contents = event.contents();
        if (this.canSee.test(contents) && this.canUse.test(contents)) {
            this.targets.stream().filter(target -> target.getType().isAssignableFrom(event.getClass())).map(target -> target).forEach(target -> target.accept(event));
        }
    }

    @Override
    @NotNull
    public <T extends IconEvent> Icon target(@NotNull Target<T> target) {
        this.targets.add(target);
        return this;
    }

    @Override
    @NotNull
    public Icon targets(@NotNull Collection<Target<? extends IconEvent>> targets) {
        this.targets.addAll(targets);
        return this;
    }

    @Override
    @NotNull
    public Icon canSee(@NotNull Predicate<InventoryContents> predicate) {
        this.canSee = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon canUse(@NotNull Predicate<InventoryContents> predicate) {
        this.canUse = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon fallback(@NotNull ItemStack fallback) {
        this.fallback = fallback;
        return this;
    }

    @Override
    @NotNull
    public Icon clone(@NotNull ItemStack newitem) {
        return Icon.from(newitem).canSee(this.canSee).canUse(this.canUse).fallback(this.fallback).targets(this.targets);
    }

    public BasicIcon(@NotNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.item = item;
    }
}

