/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.replaceable.rp;

import io.github.portlek.replaceable.Replaceable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class RpEnvelope<S extends RpEnvelope<S, X>, X>
implements Replaceable<S, X> {
    @NotNull
    private final Collection<String> regex = new ArrayList<String>();
    @NotNull
    private final Map<String, Supplier<String>> replaces = new HashMap<String, Supplier<String>>();
    @NotNull
    private final Collection<UnaryOperator<X>> maps = new ArrayList<UnaryOperator<X>>();
    @NotNull
    private final X value;

    @Override
    @NotNull
    public final S replace(@NotNull Map<String, Supplier<String>> replaces) {
        this.replaces.putAll(replaces);
        return (S)((RpEnvelope)this.self());
    }

    @Override
    @SafeVarargs
    @NotNull
    public final S replace(Map.Entry<String, Supplier<String>> ... replaces) {
        this.replaces.putAll(Arrays.stream(replaces).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return (S)((RpEnvelope)this.self());
    }

    @Override
    @NotNull
    public final S replaces(@NotNull Collection<String> regex) {
        this.regex.addAll(regex);
        return (S)((RpEnvelope)this.self());
    }

    @Override
    @NotNull
    public final S map(@NotNull Collection<UnaryOperator<X>> map) {
        this.maps.addAll(map);
        return (S)((RpEnvelope)this.self());
    }

    @Override
    @NotNull
    public final X getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public final Collection<String> getRegex() {
        return Collections.unmodifiableCollection(this.regex);
    }

    @Override
    @NotNull
    public final Map<String, Supplier<String>> getReplaces() {
        return Collections.unmodifiableMap(this.replaces);
    }

    @Override
    @NotNull
    public final Collection<UnaryOperator<X>> getMaps() {
        return Collections.unmodifiableCollection(this.maps);
    }

    public RpEnvelope(@NotNull X value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }
}

