/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.input;

import io.github.portlek.input.ChatInput;
import io.github.portlek.input.ChatInputPlugin;
import io.github.portlek.input.Sender;
import io.github.portlek.input.Task;
import io.github.portlek.input.event.ChatEvent;
import io.github.portlek.input.event.QuitEvent;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoreChatInput<T, P, S extends Sender<P>, X, A extends ChatEvent<P>, B extends QuitEvent<P>, L>
implements ChatInput<T, X, L> {
    @NotNull
    private final ChatInputPlugin<X, L> plugin;
    @NotNull
    private final S sender;
    @Nullable
    private final String invalidInputMessage;
    @Nullable
    private final String sendValueMessage;
    @NotNull
    private final BiFunction<S, String, Boolean> isValidInput;
    @NotNull
    private final BiFunction<S, String, T> setValue;
    @NotNull
    private final BiConsumer<S, T> onFinish;
    @NotNull
    private final Consumer<S> onCancel;
    @NotNull
    private final Consumer<S> onExpire;
    @NotNull
    private final String cancel;
    @NotNull
    private final BiFunction<S, String, Boolean> onInvalidInput;
    private final boolean repeat;
    private final long expire;
    @Nullable
    private T value;
    @Nullable
    private Task<X> expireTask;

    @Override
    @NotNull
    public final Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public final void start() {
        this.plugin.registerEvent(this.self());
        if (this.expire != -1L) {
            this.expireTask = this.createTask(this.plugin.createRunTaskLater(() -> this.getExpireTask().filter(task -> !task.isCancelled()).ifPresent(task -> {
                this.onExpire.accept(this.sender);
                this.unregister();
            }), this.expire));
        }
        this.getSendValueMessage().ifPresent(arg_0 -> this.sender.sendMessage(arg_0));
    }

    @Override
    public final void unregister() {
        this.unregisterListeners();
        this.getExpireTask().ifPresent(Task::cancel);
    }

    @Override
    @NotNull
    public final Optional<Task<X>> getExpireTask() {
        return Optional.ofNullable(this.expireTask);
    }

    @Override
    @NotNull
    public final Optional<String> getInvalidInputMessage() {
        return Optional.ofNullable(this.invalidInputMessage);
    }

    @Override
    @NotNull
    public final Optional<String> getSendValueMessage() {
        return Optional.ofNullable(this.sendValueMessage);
    }

    @NotNull
    public abstract Task<X> createTask(@NotNull X var1);

    public final void onChat(@NotNull A event) {
        if (!this.sender.getUniqueId().equals(event.sender().getUniqueId())) {
            return;
        }
        event.cancel();
        String message = event.message();
        if (message.equalsIgnoreCase(this.cancel)) {
            this.onCancel.accept(this.sender);
            this.unregister();
            return;
        }
        if (this.isValidInput.apply(this.sender, message).booleanValue()) {
            this.value = this.setValue.apply(this.sender, message);
            this.onFinish.accept(this.sender, this.value);
            this.unregister();
        } else {
            if (this.onInvalidInput.apply(this.sender, message).booleanValue()) {
                this.getInvalidInputMessage().ifPresent(arg_0 -> this.sender.sendMessage(arg_0));
                this.getSendValueMessage().filter(s -> this.repeat).ifPresent(arg_0 -> this.sender.sendMessage(arg_0));
            }
            if (!this.repeat) {
                this.unregister();
            }
        }
    }

    public final void onQuit(@NotNull B event) {
        if (event.sender().getUniqueId().equals(this.sender.getUniqueId())) {
            this.onCancel.accept(this.sender);
            this.unregister();
        }
    }

    public CoreChatInput(@NotNull ChatInputPlugin<X, L> plugin, @NotNull S sender, @Nullable String invalidInputMessage, @Nullable String sendValueMessage, @NotNull BiFunction<S, String, Boolean> isValidInput, @NotNull BiFunction<S, String, T> setValue, @NotNull BiConsumer<S, T> onFinish, @NotNull Consumer<S> onCancel, @NotNull Consumer<S> onExpire, @NotNull String cancel, @NotNull BiFunction<S, String, Boolean> onInvalidInput, boolean repeat, long expire) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (isValidInput == null) {
            throw new NullPointerException("isValidInput is marked non-null but is null");
        }
        if (setValue == null) {
            throw new NullPointerException("setValue is marked non-null but is null");
        }
        if (onFinish == null) {
            throw new NullPointerException("onFinish is marked non-null but is null");
        }
        if (onCancel == null) {
            throw new NullPointerException("onCancel is marked non-null but is null");
        }
        if (onExpire == null) {
            throw new NullPointerException("onExpire is marked non-null but is null");
        }
        if (cancel == null) {
            throw new NullPointerException("cancel is marked non-null but is null");
        }
        if (onInvalidInput == null) {
            throw new NullPointerException("onInvalidInput is marked non-null but is null");
        }
        this.plugin = plugin;
        this.sender = sender;
        this.invalidInputMessage = invalidInputMessage;
        this.sendValueMessage = sendValueMessage;
        this.isValidInput = isValidInput;
        this.setValue = setValue;
        this.onFinish = onFinish;
        this.onCancel = onCancel;
        this.onExpire = onExpire;
        this.cancel = cancel;
        this.onInvalidInput = onInvalidInput;
        this.repeat = repeat;
        this.expire = expire;
    }
}

