/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.input;

import io.github.portlek.input.ChatInput;
import io.github.portlek.input.ChatInputPlugin;
import io.github.portlek.input.Self;
import io.github.portlek.input.Sender;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChatInputBuilder<T, P, S extends Sender<P>, X, L, Slf extends ChatInputBuilder<T, P, S, X, L, Slf>>
implements Self<Slf> {
    @NotNull
    protected final ChatInputPlugin<X, L> plugin;
    @NotNull
    protected final S sender;
    @NotNull
    protected BiFunction<S, String, Boolean> onInvalidInput = (p, mes) -> true;
    @NotNull
    protected BiFunction<S, String, Boolean> isValidInput = (p, mes) -> true;
    @NotNull
    protected BiFunction<S, String, T> setValue = (p, mes) -> this.value;
    @NotNull
    protected BiConsumer<S, T> onFinish = (p, val) -> {};
    @NotNull
    protected Consumer<S> onCancel = p -> {};
    @NotNull
    protected Consumer<S> onExpire = p -> {};
    @Nullable
    protected String invalidInputMessage = "That is not a valid input";
    @Nullable
    protected String sendValueMessage = "Send in the chat the value";
    protected long expire = -1L;
    protected boolean repeat = true;
    @NotNull
    protected String cancel = "cancel";
    @Nullable
    protected T value;

    public ChatInputBuilder(@NotNull ChatInputPlugin<X, L> plugin, @NotNull S sender) {
        this.plugin = plugin;
        this.sender = sender;
    }

    @NotNull
    public Slf expire(long expire) {
        this.expire = expire;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf invalidInputMessage(@Nullable String message) {
        this.invalidInputMessage = message;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf sendValueMessage(@Nullable String message) {
        this.sendValueMessage = message;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf toCancel(@NotNull String cancel) {
        this.cancel = cancel;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf defaultValue(@Nullable T def) {
        this.value = def;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf repeat(boolean repeat) {
        this.repeat = repeat;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf onExpire(@NotNull Consumer<S> onExpire) {
        this.onExpire = onExpire;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf onInvalidInput(@NotNull BiFunction<S, String, Boolean> onInvalidInput) {
        this.onInvalidInput = onInvalidInput;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf isValidInput(@NotNull BiFunction<S, String, Boolean> isValidInput) {
        this.isValidInput = isValidInput;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf onFinish(@NotNull BiConsumer<S, T> onFinish) {
        this.onFinish = onFinish;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf onCancel(@NotNull Consumer<S> onCancel) {
        this.onCancel = onCancel;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public Slf setValue(@NotNull BiFunction<S, String, T> setValue) {
        this.setValue = setValue;
        return (Slf)((ChatInputBuilder)this.self());
    }

    @NotNull
    public abstract ChatInput<T, X, L> build();
}

